/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.df;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Writable;
import org.apache.mahout.df.node.Node;
import org.apache.mahout.ga.watchmaker.OutputUtils;

public final class DFUtils {
    private DFUtils() {
    }

    public static void writeArray(DataOutput out, Node[] array) throws IOException {
        out.writeInt(array.length);
        for (Node w : array) {
            w.write(out);
        }
    }

    public static Node[] readNodeArray(DataInput in) throws IOException {
        int length = in.readInt();
        Node[] nodes = new Node[length];
        for (int index = 0; index < length; ++index) {
            nodes[index] = Node.read(in);
        }
        return nodes;
    }

    public static void writeArray(DataOutput out, double[] array) throws IOException {
        out.writeInt(array.length);
        for (double value : array) {
            out.writeDouble(value);
        }
    }

    public static double[] readDoubleArray(DataInput in) throws IOException {
        int length = in.readInt();
        double[] array = new double[length];
        for (int index = 0; index < length; ++index) {
            array[index] = in.readDouble();
        }
        return array;
    }

    public static void writeArray(DataOutput out, int[] array) throws IOException {
        out.writeInt(array.length);
        for (int value : array) {
            out.writeInt(value);
        }
    }

    public static int[] readIntArray(DataInput in) throws IOException {
        int length = in.readInt();
        int[] array = new int[length];
        for (int index = 0; index < length; ++index) {
            array[index] = in.readInt();
        }
        return array;
    }

    public static Path[] listOutputFiles(FileSystem fs, Path outputPath) throws IOException {
        Path[] outfiles = OutputUtils.listOutputFiles(fs, outputPath);
        if (outfiles.length == 0) {
            throw new IOException("No output found !");
        }
        return outfiles;
    }

    public static String elapsedTime(long milli) {
        long seconds = milli / 1000L;
        long minutes = seconds / 60L;
        long hours = minutes / 60L;
        return hours + "h " + (minutes %= 60L) + "m " + (seconds %= 60L) + "s " + (milli %= 1000L);
    }

    public static void storeWritable(Configuration conf, Path path, Writable writable) throws IOException {
        FileSystem fs = path.getFileSystem(conf);
        FSDataOutputStream out = fs.create(path);
        writable.write((DataOutput)out);
        out.close();
    }
}

