/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.df;

import java.util.Arrays;
import java.util.Random;
import org.apache.mahout.df.builder.TreeBuilder;
import org.apache.mahout.df.callback.PredictionCallback;
import org.apache.mahout.df.data.Data;
import org.apache.mahout.df.node.Node;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Bagging {
    private static final Logger log = LoggerFactory.getLogger(Bagging.class);
    private final TreeBuilder treeBuilder;
    private final Data data;
    private final boolean[] sampled;

    public Bagging(TreeBuilder treeBuilder, Data data) {
        this.treeBuilder = treeBuilder;
        this.data = data;
        this.sampled = new boolean[data.size()];
    }

    public Node build(int treeId, Random rng, PredictionCallback callback) {
        log.debug("Bagging...");
        Arrays.fill(this.sampled, false);
        Data bag = this.data.bagging(rng, this.sampled);
        log.debug("Building...");
        Node tree = this.treeBuilder.build(rng, bag);
        if (callback != null) {
            log.debug("Oob error estimation");
            for (int index = 0; index < this.data.size(); ++index) {
                if (this.sampled[index]) continue;
                int prediction = tree.classify(this.data.get(index));
                callback.prediction(treeId, index, prediction);
            }
        }
        return tree;
    }
}

