/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.common.nlp;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;

public class NGrams {
    private final String line;
    private final int gramSize;

    public NGrams(String line, int gramSize) {
        this.line = line;
        this.gramSize = gramSize;
    }

    public Map<String, List<String>> generateNGrams() {
        HashMap<String, List<String>> returnDocument = new HashMap<String, List<String>>();
        StringTokenizer tokenizer = new StringTokenizer(this.line);
        ArrayList<String> tokens = new ArrayList<String>();
        String labelName = tokenizer.nextToken();
        ArrayList<String> previousN1Grams = new ArrayList<String>();
        while (tokenizer.hasMoreTokens()) {
            String nextToken = tokenizer.nextToken();
            if (previousN1Grams.size() == this.gramSize) {
                previousN1Grams.remove(0);
            }
            previousN1Grams.add(nextToken);
            StringBuilder gramBuilder = new StringBuilder();
            for (String gram : previousN1Grams) {
                gramBuilder.append(gram);
                String token = gramBuilder.toString();
                tokens.add(token);
                gramBuilder.append(' ');
            }
        }
        returnDocument.put(labelName, tokens);
        return returnDocument;
    }

    public List<String> generateNGramsWithoutLabel() {
        StringTokenizer tokenizer = new StringTokenizer(this.line);
        ArrayList<String> tokens = new ArrayList<String>();
        ArrayList<String> previousN1Grams = new ArrayList<String>();
        while (tokenizer.hasMoreTokens()) {
            String nextToken = tokenizer.nextToken();
            if (previousN1Grams.size() == this.gramSize) {
                previousN1Grams.remove(0);
            }
            previousN1Grams.add(nextToken);
            StringBuilder gramBuilder = new StringBuilder();
            for (String gram : previousN1Grams) {
                gramBuilder.append(gram);
                String token = gramBuilder.toString();
                tokens.add(token);
                gramBuilder.append(' ');
            }
        }
        return tokens;
    }
}

