/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.common.iterator.sequencefile;

import com.google.common.base.Function;
import com.google.common.collect.ForwardingIterator;
import com.google.common.collect.Iterators;
import com.google.common.collect.UnmodifiableIterator;
import java.io.IOException;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.io.Writable;
import org.apache.mahout.common.Pair;
import org.apache.mahout.common.iterator.sequencefile.PathType;
import org.apache.mahout.common.iterator.sequencefile.SequenceFileIterator;

public final class SequenceFileDirIterator<K extends Writable, V extends Writable>
extends ForwardingIterator<Pair<K, V>> {
    private final Iterator<Pair<K, V>> delegate;

    public SequenceFileDirIterator(Path path, PathType pathType, PathFilter filter, Comparator<FileStatus> ordering, final boolean reuseKeyValueInstances, final Configuration conf) throws IOException {
        Object[] statuses;
        FileSystem fs = path.getFileSystem(conf);
        if (filter == null) {
            statuses = pathType == PathType.GLOB ? fs.globStatus(path) : fs.listStatus(path);
        } else {
            Object[] objectArray = statuses = pathType == PathType.GLOB ? fs.globStatus(path, filter) : fs.listStatus(path, filter);
        }
        if (ordering != null) {
            Arrays.sort(statuses, ordering);
        }
        UnmodifiableIterator fileStatusIterator = Iterators.forArray((Object[])statuses);
        Iterator fsIterators = Iterators.transform((Iterator)fileStatusIterator, (Function)new Function<FileStatus, Iterator<Pair<K, V>>>(){

            public Iterator<Pair<K, V>> apply(FileStatus from) {
                try {
                    return new SequenceFileIterator(from.getPath(), reuseKeyValueInstances, conf);
                }
                catch (IOException ioe) {
                    throw new IllegalStateException(ioe);
                }
            }
        });
        this.delegate = Iterators.concat((Iterator)fsIterators);
    }

    protected Iterator<Pair<K, V>> delegate() {
        return this.delegate;
    }
}

