/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.common.iterator.sequencefile;

import java.io.IOException;
import java.util.Comparator;
import java.util.Iterator;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.io.Writable;
import org.apache.mahout.common.Pair;
import org.apache.mahout.common.iterator.sequencefile.PathType;
import org.apache.mahout.common.iterator.sequencefile.SequenceFileDirIterator;

public final class SequenceFileDirIterable<K extends Writable, V extends Writable>
implements Iterable<Pair<K, V>> {
    private final Path path;
    private final PathType pathType;
    private final PathFilter filter;
    private final Comparator<FileStatus> ordering;
    private final boolean reuseKeyValueInstances;
    private final Configuration conf;

    public SequenceFileDirIterable(Path path, PathType pathType, Configuration conf) {
        this(path, pathType, null, conf);
    }

    public SequenceFileDirIterable(Path path, PathType pathType, PathFilter filter, Configuration conf) {
        this(path, pathType, filter, null, false, conf);
    }

    public SequenceFileDirIterable(Path path, PathType pathType, PathFilter filter, Comparator<FileStatus> ordering, boolean reuseKeyValueInstances, Configuration conf) {
        this.path = path;
        this.pathType = pathType;
        this.filter = filter;
        this.ordering = ordering;
        this.reuseKeyValueInstances = reuseKeyValueInstances;
        this.conf = conf;
    }

    @Override
    public Iterator<Pair<K, V>> iterator() {
        try {
            return new SequenceFileDirIterator(this.path, this.pathType, this.filter, this.ordering, this.reuseKeyValueInstances, this.conf);
        }
        catch (IOException ioe) {
            throw new IllegalStateException(ioe);
        }
    }
}

