/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.common.iterator;

import com.google.common.base.Function;
import com.google.common.collect.ForwardingIterator;
import com.google.common.collect.Iterators;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.Random;
import org.apache.mahout.common.Pair;
import org.apache.mahout.common.RandomUtils;

public class StableFixedSizeSamplingIterator<T>
extends ForwardingIterator<T> {
    private final Iterator<T> delegate;

    public StableFixedSizeSamplingIterator(int size, Iterator<T> source) {
        ArrayList<Pair<Integer, T>> buf = new ArrayList<Pair<Integer, T>>(size);
        int sofar = 0;
        Random random = RandomUtils.getRandom();
        while (source.hasNext()) {
            T v = source.next();
            ++sofar;
            if (buf.size() < size) {
                buf.add(new Pair<Integer, T>(sofar, v));
                continue;
            }
            int position = random.nextInt(sofar);
            if (position >= buf.size()) continue;
            buf.set(position, new Pair<Integer, T>(sofar, v));
        }
        Collections.sort(buf);
        this.delegate = Iterators.transform(buf.iterator(), (Function)new Function<Pair<Integer, T>, T>(){

            public T apply(Pair<Integer, T> from) {
                return from.getSecond();
            }
        });
    }

    protected Iterator<T> delegate() {
        return this.delegate;
    }
}

