/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.common.iterator;

import com.google.common.collect.AbstractIterator;
import java.util.Iterator;
import java.util.Random;
import org.apache.mahout.cf.taste.impl.common.SkippingIterator;
import org.apache.mahout.common.RandomUtils;

public final class SamplingIterator<T>
extends AbstractIterator<T> {
    private static final Random RANDOM = RandomUtils.getRandom();
    private final Iterator<? extends T> delegate;
    private final double samplingRate;

    public SamplingIterator(Iterator<? extends T> delegate, double samplingRate) {
        this.delegate = delegate;
        this.samplingRate = samplingRate;
    }

    protected T computeNext() {
        if (this.delegate instanceof SkippingIterator) {
            SkippingIterator skippingDelegate = (SkippingIterator)this.delegate;
            int toSkip = 0;
            while (RANDOM.nextDouble() >= this.samplingRate) {
                ++toSkip;
            }
            if (toSkip > 0) {
                skippingDelegate.skip(toSkip);
            }
            if (skippingDelegate.hasNext()) {
                return (T)skippingDelegate.next();
            }
        } else {
            while (this.delegate.hasNext()) {
                T delegateNext = this.delegate.next();
                if (!(RANDOM.nextDouble() < this.samplingRate)) continue;
                return delegateNext;
            }
        }
        return (T)this.endOfData();
    }
}

