/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.common.iterator;

import java.util.Iterator;
import org.apache.mahout.common.iterator.SamplingIterator;

public final class SamplingIterable<T>
implements Iterable<T> {
    private final Iterable<? extends T> delegate;
    private final double samplingRate;

    public SamplingIterable(Iterable<? extends T> delegate, double samplingRate) {
        this.delegate = delegate;
        this.samplingRate = samplingRate;
    }

    @Override
    public Iterator<T> iterator() {
        return new SamplingIterator<T>(this.delegate.iterator(), this.samplingRate);
    }

    public static <T> Iterable<T> maybeWrapIterable(Iterable<T> delegate, double samplingRate) {
        return samplingRate >= 1.0 ? delegate : new SamplingIterable<T>(delegate, samplingRate);
    }
}

