/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.common.distance;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.mahout.common.distance.DistanceMeasure;
import org.apache.mahout.common.parameters.DoubleParameter;
import org.apache.mahout.common.parameters.Parameter;
import org.apache.mahout.common.parameters.Parametered;
import org.apache.mahout.math.Vector;

public class MinkowskiDistanceMeasure
implements DistanceMeasure {
    private static final double EXPONENT = 3.0;
    private List<Parameter<?>> parameters;
    private double exponent = 3.0;

    public MinkowskiDistanceMeasure() {
    }

    public MinkowskiDistanceMeasure(double exponent) {
        this.exponent = exponent;
    }

    @Override
    public void createParameters(String prefix, Configuration conf) {
        this.parameters = new ArrayList();
        DoubleParameter param = new DoubleParameter(prefix, "exponent", conf, 3.0, "Exponent for Fractional Lagrange distance");
        this.parameters.add(param);
    }

    @Override
    public Collection<Parameter<?>> getParameters() {
        return this.parameters;
    }

    @Override
    public void configure(Configuration jobConf) {
        if (this.parameters == null) {
            Parametered.ParameteredGeneralizations.configureParameters(this, jobConf);
        }
    }

    public double getExponent() {
        return this.exponent;
    }

    public void setExponent(double exponent) {
        this.exponent = exponent;
    }

    @Override
    public double distance(Vector v1, Vector v2) {
        Vector distVector = v1.minus(v2);
        double sum = 0.0;
        Iterator it = distVector.iterateNonZero();
        while (it.hasNext()) {
            Vector.Element e = (Vector.Element)it.next();
            sum += Math.pow(Math.abs(e.get()), this.exponent);
        }
        return Math.pow(sum, 1.0 / this.exponent);
    }

    @Override
    public double distance(double centroidLengthSquare, Vector centroid, Vector v) {
        return this.distance(centroid, v);
    }
}

