/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.common.commandline;

import org.apache.commons.cli2.Option;
import org.apache.commons.cli2.builder.ArgumentBuilder;
import org.apache.commons.cli2.builder.DefaultOptionBuilder;
import org.apache.mahout.common.distance.SquaredEuclideanDistanceMeasure;

public final class DefaultOptionCreator {
    public static final String CLUSTERING_OPTION = "clustering";
    public static final String CLUSTERS_IN_OPTION = "clusters";
    public static final String CONVERGENCE_DELTA_OPTION = "convergenceDelta";
    public static final String DISTANCE_MEASURE_OPTION = "distanceMeasure";
    public static final String EMIT_MOST_LIKELY_OPTION = "emitMostLikely";
    public static final String INPUT_OPTION = "input";
    public static final String MAX_ITERATIONS_OPTION = "maxIter";
    public static final String MAX_REDUCERS_OPTION = "maxRed";
    public static final String METHOD_OPTION = "method";
    public static final String NUM_CLUSTERS_OPTION = "numClusters";
    public static final String OUTPUT_OPTION = "output";
    public static final String OVERWRITE_OPTION = "overwrite";
    public static final String T1_OPTION = "t1";
    public static final String T2_OPTION = "t2";
    public static final String T3_OPTION = "t3";
    public static final String T4_OPTION = "t4";
    public static final String THRESHOLD_OPTION = "threshold";
    public static final String SEQUENTIAL_METHOD = "sequential";
    public static final String MAPREDUCE_METHOD = "mapreduce";

    private DefaultOptionCreator() {
    }

    public static Option helpOption() {
        return new DefaultOptionBuilder().withLongName("help").withDescription("Print out help").withShortName("h").create();
    }

    public static DefaultOptionBuilder inputOption() {
        return new DefaultOptionBuilder().withLongName(INPUT_OPTION).withRequired(false).withShortName("i").withArgument(new ArgumentBuilder().withName(INPUT_OPTION).withMinimum(1).withMaximum(1).create()).withDescription("Path to job input directory.");
    }

    public static DefaultOptionBuilder clustersInOption() {
        return new DefaultOptionBuilder().withLongName(CLUSTERS_IN_OPTION).withRequired(true).withArgument(new ArgumentBuilder().withName(CLUSTERS_IN_OPTION).withMinimum(1).withMaximum(1).create()).withDescription("The path to the initial clusters directory. Must be a SequenceFile of some type of Cluster").withShortName("c");
    }

    public static DefaultOptionBuilder outputOption() {
        return new DefaultOptionBuilder().withLongName(OUTPUT_OPTION).withRequired(false).withShortName("o").withArgument(new ArgumentBuilder().withName(OUTPUT_OPTION).withMinimum(1).withMaximum(1).create()).withDescription("The directory pathname for output.");
    }

    public static DefaultOptionBuilder overwriteOption() {
        return new DefaultOptionBuilder().withLongName(OVERWRITE_OPTION).withRequired(false).withDescription("If present, overwrite the output directory before running job").withShortName("ow");
    }

    public static DefaultOptionBuilder distanceMeasureOption() {
        return new DefaultOptionBuilder().withLongName(DISTANCE_MEASURE_OPTION).withRequired(false).withShortName("dm").withArgument(new ArgumentBuilder().withName(DISTANCE_MEASURE_OPTION).withDefault((Object)SquaredEuclideanDistanceMeasure.class.getName()).withMinimum(1).withMaximum(1).create()).withDescription("The classname of the DistanceMeasure. Default is SquaredEuclidean");
    }

    public static DefaultOptionBuilder methodOption() {
        return new DefaultOptionBuilder().withLongName(METHOD_OPTION).withRequired(false).withShortName("xm").withArgument(new ArgumentBuilder().withName(METHOD_OPTION).withDefault((Object)MAPREDUCE_METHOD).withMinimum(1).withMaximum(1).create()).withDescription("The execution method to use: sequential or mapreduce. Default is mapreduce");
    }

    public static DefaultOptionBuilder t1Option() {
        return new DefaultOptionBuilder().withLongName(T1_OPTION).withRequired(true).withArgument(new ArgumentBuilder().withName(T1_OPTION).withMinimum(1).withMaximum(1).create()).withDescription("T1 threshold value").withShortName(T1_OPTION);
    }

    public static DefaultOptionBuilder t2Option() {
        return new DefaultOptionBuilder().withLongName(T2_OPTION).withRequired(true).withArgument(new ArgumentBuilder().withName(T2_OPTION).withMinimum(1).withMaximum(1).create()).withDescription("T2 threshold value").withShortName(T2_OPTION);
    }

    public static DefaultOptionBuilder t3Option() {
        return new DefaultOptionBuilder().withLongName(T3_OPTION).withRequired(false).withArgument(new ArgumentBuilder().withName(T3_OPTION).withMinimum(1).withMaximum(1).create()).withDescription("T3 (Reducer T1) threshold value").withShortName(T3_OPTION);
    }

    public static DefaultOptionBuilder t4Option() {
        return new DefaultOptionBuilder().withLongName(T4_OPTION).withRequired(false).withArgument(new ArgumentBuilder().withName(T4_OPTION).withMinimum(1).withMaximum(1).create()).withDescription("T4 (Reducer T2) threshold value").withShortName(T4_OPTION);
    }

    public static DefaultOptionBuilder maxIterationsOption() {
        return new DefaultOptionBuilder().withLongName(MAX_ITERATIONS_OPTION).withRequired(true).withShortName("x").withArgument(new ArgumentBuilder().withName(MAX_ITERATIONS_OPTION).withDefault((Object)"-1").withMinimum(1).withMaximum(1).create()).withDescription("The maximum number of iterations.");
    }

    public static DefaultOptionBuilder numClustersOption() {
        return new DefaultOptionBuilder().withLongName(NUM_CLUSTERS_OPTION).withRequired(false).withArgument(new ArgumentBuilder().withName("k").withMinimum(1).withMaximum(1).create()).withDescription("The number of clusters to create").withShortName("k");
    }

    public static DefaultOptionBuilder convergenceOption() {
        return new DefaultOptionBuilder().withLongName(CONVERGENCE_DELTA_OPTION).withRequired(false).withShortName("cd").withArgument(new ArgumentBuilder().withName(CONVERGENCE_DELTA_OPTION).withDefault((Object)"0.5").withMinimum(1).withMaximum(1).create()).withDescription("The convergence delta value. Default is 0.5");
    }

    @Deprecated
    public static DefaultOptionBuilder numReducersOption() {
        return new DefaultOptionBuilder().withLongName(MAX_REDUCERS_OPTION).withRequired(false).withShortName("r").withArgument(new ArgumentBuilder().withName(MAX_REDUCERS_OPTION).withDefault((Object)"2").withMinimum(1).withMaximum(1).create()).withDescription("The number of reduce tasks. Defaults to 2");
    }

    public static DefaultOptionBuilder clusteringOption() {
        return new DefaultOptionBuilder().withLongName(CLUSTERING_OPTION).withRequired(false).withDescription("If present, run clustering after the iterations have taken place").withShortName("cl");
    }

    public static DefaultOptionBuilder emitMostLikelyOption() {
        return new DefaultOptionBuilder().withLongName(EMIT_MOST_LIKELY_OPTION).withRequired(false).withShortName("e").withArgument(new ArgumentBuilder().withName(EMIT_MOST_LIKELY_OPTION).withDefault((Object)"true").withMinimum(1).withMaximum(1).create()).withDescription("True if clustering should emit the most likely point only, false for threshold clustering. Default is true");
    }

    public static DefaultOptionBuilder thresholdOption() {
        return new DefaultOptionBuilder().withLongName(THRESHOLD_OPTION).withRequired(false).withShortName("t").withArgument(new ArgumentBuilder().withName(THRESHOLD_OPTION).withDefault((Object)"0").withMinimum(1).withMaximum(1).create()).withDescription("The pdf threshold used for cluster determination. Default is 0");
    }
}

