/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.common;

import java.io.IOException;
import java.util.Arrays;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.mahout.common.iterator.sequencefile.SequenceFileValueIterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class HadoopUtil {
    private static final Logger log = LoggerFactory.getLogger(HadoopUtil.class);

    private HadoopUtil() {
    }

    public static void delete(Configuration conf, Iterable<Path> paths) throws IOException {
        if (conf == null) {
            conf = new Configuration();
        }
        for (Path path : paths) {
            FileSystem fs = path.getFileSystem(conf);
            if (!fs.exists(path)) continue;
            log.info("Deleting {}", (Object)path);
            fs.delete(path, true);
        }
    }

    public static void delete(Configuration conf, Path ... paths) throws IOException {
        HadoopUtil.delete(conf, Arrays.asList(paths));
    }

    public static long countRecords(Path path, Configuration conf) throws IOException {
        long count = 0L;
        SequenceFileValueIterator iterator = new SequenceFileValueIterator(path, true, conf);
        while (iterator.hasNext()) {
            iterator.next();
            ++count;
        }
        return count;
    }
}

