/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.common;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.cli2.CommandLine;
import org.apache.commons.cli2.Group;
import org.apache.commons.cli2.Option;
import org.apache.commons.cli2.OptionException;
import org.apache.commons.cli2.builder.ArgumentBuilder;
import org.apache.commons.cli2.builder.DefaultOptionBuilder;
import org.apache.commons.cli2.builder.GroupBuilder;
import org.apache.commons.cli2.commandline.Parser;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapreduce.InputFormat;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.OutputFormat;
import org.apache.hadoop.mapreduce.Reducer;
import org.apache.hadoop.util.Tool;
import org.apache.mahout.common.CommandLineUtil;
import org.apache.mahout.common.commandline.DefaultOptionCreator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractJob
extends Configured
implements Tool {
    private static final Logger log = LoggerFactory.getLogger(AbstractJob.class);
    private Option inputOption;
    private Option outputOption;
    private Path inputPath;
    private Path outputPath;
    private Map<String, String> argMap;
    private final List<Option> options = new LinkedList<Option>();

    protected AbstractJob() {
    }

    protected Path getInputPath() {
        return this.inputPath;
    }

    protected Path getOutputPath() {
        return this.outputPath;
    }

    protected void addFlag(String name, String shortName, String description) {
        this.options.add(AbstractJob.buildOption(name, shortName, description, false, false, null));
    }

    protected void addOption(String name, String shortName, String description) {
        this.options.add(AbstractJob.buildOption(name, shortName, description, true, false, null));
    }

    protected void addOption(String name, String shortName, String description, boolean required) {
        this.options.add(AbstractJob.buildOption(name, shortName, description, true, required, null));
    }

    protected void addOption(String name, String shortName, String description, String defaultValue) {
        this.options.add(AbstractJob.buildOption(name, shortName, description, true, false, defaultValue));
    }

    protected Option addOption(Option option) {
        this.options.add(option);
        return option;
    }

    protected void addInputOption() {
        this.inputOption = this.addOption((Option)DefaultOptionCreator.inputOption().create());
    }

    protected void addOutputOption() {
        this.outputOption = this.addOption((Option)DefaultOptionCreator.outputOption().create());
    }

    protected static Option buildOption(String name, String shortName, String description, boolean hasArg, boolean required, String defaultValue) {
        DefaultOptionBuilder optBuilder = new DefaultOptionBuilder().withLongName(name).withDescription(description).withRequired(required);
        if (shortName != null) {
            optBuilder.withShortName(shortName);
        }
        if (hasArg) {
            ArgumentBuilder argBuilder = new ArgumentBuilder().withName(name).withMinimum(1).withMaximum(1);
            if (defaultValue != null) {
                argBuilder = argBuilder.withDefault((Object)defaultValue);
            }
            optBuilder.withArgument(argBuilder.create());
        }
        return optBuilder.create();
    }

    public Map<String, String> parseArguments(String[] args) {
        CommandLine cmdLine;
        Option helpOpt = this.addOption(DefaultOptionCreator.helpOption());
        this.addOption("tempDir", null, "Intermediate output directory", "temp");
        this.addOption("startPhase", null, "First phase to run", "0");
        this.addOption("endPhase", null, "Last phase to run", String.valueOf(Integer.MAX_VALUE));
        GroupBuilder gBuilder = new GroupBuilder().withName("Job-Specific Options:");
        for (Option opt : this.options) {
            gBuilder = gBuilder.withOption(opt);
        }
        Group group = gBuilder.create();
        try {
            Parser parser = new Parser();
            parser.setGroup(group);
            parser.setHelpOption(helpOpt);
            cmdLine = parser.parse(args);
        }
        catch (OptionException e) {
            log.error(e.getMessage());
            CommandLineUtil.printHelpWithGenericOptions(group, e);
            return null;
        }
        if (cmdLine.hasOption(helpOpt)) {
            CommandLineUtil.printHelpWithGenericOptions(group);
            return null;
        }
        try {
            this.parseDirectories(cmdLine);
        }
        catch (IllegalArgumentException e) {
            log.error(e.getMessage());
            CommandLineUtil.printHelpWithGenericOptions(group);
            return null;
        }
        this.argMap = new TreeMap<String, String>();
        AbstractJob.maybePut(this.argMap, cmdLine, this.options.toArray(new Option[this.options.size()]));
        log.info("Command line arguments: {}", this.argMap);
        return this.argMap;
    }

    public static String keyFor(String optionName) {
        return "--" + optionName;
    }

    public String getOption(String optionName) {
        return this.argMap.get(AbstractJob.keyFor(optionName));
    }

    public boolean hasOption(String optionName) {
        return this.argMap.containsKey(AbstractJob.keyFor(optionName));
    }

    protected void parseDirectories(CommandLine cmdLine) {
        Configuration conf = this.getConf();
        if (this.inputOption != null && cmdLine.hasOption(this.inputOption)) {
            this.inputPath = new Path(cmdLine.getValue(this.inputOption).toString());
        }
        if (this.inputPath == null && conf.get("mapred.input.dir") != null) {
            this.inputPath = new Path(conf.get("mapred.input.dir"));
        }
        if (this.outputOption != null && cmdLine.hasOption(this.outputOption)) {
            this.outputPath = new Path(cmdLine.getValue(this.outputOption).toString());
        }
        if (this.outputPath == null && conf.get("mapred.output.dir") != null) {
            this.outputPath = new Path(conf.get("mapred.output.dir"));
        }
        Preconditions.checkArgument((this.inputOption == null || this.inputPath != null ? 1 : 0) != 0, (Object)"No input specified or -Dmapred.input.dir must be provided to specify input directory");
        Preconditions.checkArgument((this.outputOption == null || this.outputPath != null ? 1 : 0) != 0, (Object)"No output specified:  or -Dmapred.output.dir must be provided to specify output directory");
    }

    protected static void maybePut(Map<String, String> args, CommandLine cmdLine, Option ... opt) {
        for (Option o : opt) {
            if (!cmdLine.hasOption(o) && cmdLine.getValue(o) == null) continue;
            Object vo = cmdLine.getValue(o);
            String value = vo == null ? null : vo.toString();
            args.put(o.getPreferredName(), value);
        }
    }

    protected static boolean shouldRunNextPhase(Map<String, String> args, AtomicInteger currentPhase) {
        boolean phaseSkipped;
        int phase = currentPhase.getAndIncrement();
        String startPhase = args.get("--startPhase");
        String endPhase = args.get("--endPhase");
        boolean bl = phaseSkipped = startPhase != null && phase < Integer.parseInt(startPhase) || endPhase != null && phase > Integer.parseInt(endPhase);
        if (phaseSkipped) {
            log.info("Skipping phase {}", (Object)phase);
        }
        return !phaseSkipped;
    }

    protected Job prepareJob(Path inputPath, Path outputPath, Class<? extends InputFormat> inputFormat, Class<? extends Mapper> mapper, Class<? extends Writable> mapperKey, Class<? extends Writable> mapperValue, Class<? extends Reducer> reducer, Class<? extends Writable> reducerKey, Class<? extends Writable> reducerValue, Class<? extends OutputFormat> outputFormat) throws IOException {
        Job job = new Job(new Configuration(this.getConf()));
        Configuration jobConf = job.getConfiguration();
        if (reducer.equals(Reducer.class)) {
            if (mapper.equals(Mapper.class)) {
                throw new IllegalStateException("Can't figure out the user class jar file from mapper/reducer");
            }
            job.setJarByClass(mapper);
        } else {
            job.setJarByClass(reducer);
        }
        job.setInputFormatClass(inputFormat);
        jobConf.set("mapred.input.dir", inputPath.toString());
        job.setMapperClass(mapper);
        job.setMapOutputKeyClass(mapperKey);
        job.setMapOutputValueClass(mapperValue);
        jobConf.setBoolean("mapred.compress.map.output", true);
        job.setReducerClass(reducer);
        job.setOutputKeyClass(reducerKey);
        job.setOutputValueClass(reducerValue);
        job.setJobName(this.getCustomJobName((JobContext)job, mapper, reducer));
        job.setOutputFormatClass(outputFormat);
        jobConf.set("mapred.output.dir", outputPath.toString());
        return job;
    }

    private String getCustomJobName(JobContext job, Class<? extends Mapper> mapper, Class<? extends Reducer> reducer) {
        StringBuilder name = new StringBuilder(100);
        String customJobName = job.getJobName();
        if (customJobName == null || customJobName.trim().length() == 0) {
            name.append(((Object)((Object)this)).getClass().getSimpleName());
        } else {
            name.append(customJobName);
        }
        name.append('-').append(mapper.getSimpleName());
        name.append('-').append(reducer.getSimpleName());
        return name.toString();
    }
}

