/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.clustering.spectral.eigencuts;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.mapreduce.Reducer;
import org.apache.mahout.clustering.spectral.eigencuts.EigencutsSensitivityNode;
import org.apache.mahout.math.RandomAccessSparseVector;
import org.apache.mahout.math.Vector;
import org.apache.mahout.math.VectorWritable;

public class EigencutsSensitivityReducer
extends Reducer<IntWritable, EigencutsSensitivityNode, IntWritable, VectorWritable> {
    protected void reduce(IntWritable key, Iterable<EigencutsSensitivityNode> arr, Reducer.Context context) throws IOException, InterruptedException {
        Configuration conf = context.getConfiguration();
        RandomAccessSparseVector v = new RandomAccessSparseVector(conf.getInt("org.apache.mahout.clustering.spectral.eigencuts.affinitydimensions", Integer.MAX_VALUE), 100);
        double threshold = Double.parseDouble(conf.get("org.apache.mahout.clustering.spectral.tau")) / Double.parseDouble(conf.get("org.apache.mahout.clustering.spectral.delta"));
        for (EigencutsSensitivityNode n : arr) {
            if (!(n.getSensitivity() < threshold) || !(n.getSensitivity() < v.getQuick(n.getColumn()))) continue;
            v.setQuick(n.getColumn(), n.getSensitivity());
        }
        context.write((Object)key, (Object)new VectorWritable((Vector)v));
    }
}

