/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.clustering.spectral.eigencuts;

import java.io.IOException;
import java.util.HashMap;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.mahout.clustering.spectral.common.VectorCache;
import org.apache.mahout.clustering.spectral.eigencuts.EigencutsSensitivityNode;
import org.apache.mahout.math.DenseVector;
import org.apache.mahout.math.SequentialAccessSparseVector;
import org.apache.mahout.math.Vector;
import org.apache.mahout.math.VectorWritable;
import org.apache.mahout.math.function.Functions;

public class EigencutsSensitivityMapper
extends Mapper<IntWritable, VectorWritable, IntWritable, EigencutsSensitivityNode> {
    private Vector eigenvalues;
    private Vector diagonal;
    private double beta0;
    private double epsilon;

    protected void setup(Mapper.Context context) throws IOException, InterruptedException {
        super.setup(context);
        Configuration config = context.getConfiguration();
        this.beta0 = Double.parseDouble(config.get("org.apache.mahout.clustering.spectral.beta"));
        this.epsilon = Double.parseDouble(config.get("org.apache.mahout.clustering.spectral.epsilon"));
        this.eigenvalues = VectorCache.load(config);
        this.diagonal = VectorCache.load(config);
        if (!(this.eigenvalues instanceof SequentialAccessSparseVector) && !(this.eigenvalues instanceof DenseVector)) {
            this.eigenvalues = new SequentialAccessSparseVector(this.eigenvalues);
        }
        if (!(this.diagonal instanceof SequentialAccessSparseVector) && !(this.diagonal instanceof DenseVector)) {
            this.diagonal = new SequentialAccessSparseVector(this.diagonal);
        }
    }

    protected void map(IntWritable row, VectorWritable vw, Mapper.Context context) throws IOException, InterruptedException {
        double eigenvalue = Math.abs(this.eigenvalues.get(row.get()));
        double betak = -Functions.LOGARITHM.apply(2.0) / Functions.LOGARITHM.apply(eigenvalue);
        if (eigenvalue >= 1.0 || betak <= this.epsilon * this.beta0) {
            return;
        }
        HashMap<Integer, EigencutsSensitivityNode> columns = new HashMap<Integer, EigencutsSensitivityNode>();
        Vector ev = vw.get();
        for (int i = 0; i < ev.size(); ++i) {
            double minsij = Double.MAX_VALUE;
            int minInd = -1;
            for (int j = 0; j < ev.size(); ++j) {
                double sij = this.performSensitivityCalculation(eigenvalue, ev.get(i), ev.get(j), this.diagonal.get(i), this.diagonal.get(j));
                if (!(sij < minsij)) continue;
                minsij = sij;
                minInd = j;
            }
            Integer column = minInd;
            EigencutsSensitivityNode value = new EigencutsSensitivityNode(i, minInd, minsij);
            if (!columns.containsKey(column)) {
                columns.put(column, value);
                continue;
            }
            if (!(((EigencutsSensitivityNode)columns.get(column)).getSensitivity() > minsij)) continue;
            columns.remove(column);
            columns.put(column, value);
        }
        for (EigencutsSensitivityNode e : columns.values()) {
            context.write((Object)new IntWritable(e.getRow()), (Object)e);
        }
    }

    private double performSensitivityCalculation(double eigenvalue, double evi, double evj, double diagi, double diagj) {
        double firsthalf = Functions.LOGARITHM.apply(2.0) / (eigenvalue * Functions.LOGARITHM.apply(eigenvalue) * Functions.LOGARITHM.apply(Functions.POW.apply(eigenvalue, this.beta0) / 2.0));
        double secondhalf = -Functions.POW.apply(evi / Functions.SQRT.apply(diagi) - evj / Functions.SQRT.apply(diagj), 2.0) + (1.0 - eigenvalue) * (Functions.POW.apply(evi, 2.0) / diagi + Functions.POW.apply(evj, 2.0) / diagj);
        return firsthalf * secondhalf;
    }

    void setup(double beta0, double epsilon, Vector eigenvalues, Vector diagonal) {
        this.beta0 = beta0;
        this.epsilon = epsilon;
        this.eigenvalues = eigenvalues;
        this.diagonal = diagonal;
    }
}

