/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.clustering.spectral.eigencuts;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;
import org.apache.hadoop.mapreduce.lib.input.SequenceFileInputFormat;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;
import org.apache.hadoop.mapreduce.lib.output.SequenceFileOutputFormat;
import org.apache.mahout.clustering.spectral.common.VectorCache;
import org.apache.mahout.clustering.spectral.eigencuts.EigencutsSensitivityMapper;
import org.apache.mahout.clustering.spectral.eigencuts.EigencutsSensitivityNode;
import org.apache.mahout.clustering.spectral.eigencuts.EigencutsSensitivityReducer;
import org.apache.mahout.math.Vector;
import org.apache.mahout.math.VectorWritable;

public final class EigencutsSensitivityJob {
    private EigencutsSensitivityJob() {
    }

    public static void runJob(Vector eigenvalues, Vector diagonal, Path eigenvectors, double beta, double tau, double delta, double epsilon, Path output) throws IOException, ClassNotFoundException, InterruptedException {
        Configuration jobConfig = new Configuration();
        Path eigenOutputPath = new Path(output.getParent(), "eigenvalues");
        Path diagOutputPath = new Path(output.getParent(), "diagonal");
        jobConfig.set("org.apache.mahout.clustering.spectral.eigencuts.vectorcache", output.getParent().getName());
        VectorCache.save((Writable)new IntWritable(0), eigenvalues, eigenOutputPath, jobConfig);
        VectorCache.save((Writable)new IntWritable(1), diagonal, diagOutputPath, jobConfig);
        jobConfig.set("org.apache.mahout.clustering.spectral.beta", Double.toString(beta));
        jobConfig.set("org.apache.mahout.clustering.spectral.epsilon", Double.toString(epsilon));
        jobConfig.set("org.apache.mahout.clustering.spectral.delta", Double.toString(delta));
        jobConfig.set("org.apache.mahout.clustering.spectral.tau", Double.toString(tau));
        Job job = new Job(jobConfig, "EigencutsSensitivityJob");
        job.setInputFormatClass(SequenceFileInputFormat.class);
        job.setMapOutputKeyClass(IntWritable.class);
        job.setMapOutputValueClass(EigencutsSensitivityNode.class);
        job.setOutputKeyClass(IntWritable.class);
        job.setOutputValueClass(VectorWritable.class);
        job.setOutputFormatClass(SequenceFileOutputFormat.class);
        job.setMapperClass(EigencutsSensitivityMapper.class);
        job.setReducerClass(EigencutsSensitivityReducer.class);
        FileInputFormat.addInputPath((Job)job, (Path)eigenvectors);
        FileOutputFormat.setOutputPath((Job)job, (Path)output);
        job.waitForCompletion(true);
    }
}

