/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.clustering.spectral.eigencuts;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.apache.commons.cli2.Option;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.apache.mahout.clustering.spectral.common.AffinityMatrixInputJob;
import org.apache.mahout.clustering.spectral.common.MatrixDiagonalizeJob;
import org.apache.mahout.clustering.spectral.common.VectorMatrixMultiplicationJob;
import org.apache.mahout.clustering.spectral.eigencuts.EigencutsAffinityCutsJob;
import org.apache.mahout.clustering.spectral.eigencuts.EigencutsSensitivityJob;
import org.apache.mahout.common.AbstractJob;
import org.apache.mahout.common.HadoopUtil;
import org.apache.mahout.common.commandline.DefaultOptionCreator;
import org.apache.mahout.math.DenseVector;
import org.apache.mahout.math.Vector;
import org.apache.mahout.math.VectorIterable;
import org.apache.mahout.math.decomposer.lanczos.LanczosState;
import org.apache.mahout.math.hadoop.DistributedRowMatrix;
import org.apache.mahout.math.hadoop.decomposer.DistributedLanczosSolver;
import org.apache.mahout.math.hadoop.decomposer.EigenVerificationJob;
import org.apache.mahout.math.stats.OnlineSummarizer;

public class EigencutsDriver
extends AbstractJob {
    public static final double EPSILON_DEFAULT = 0.25;
    public static final double TAU_DEFAULT = -0.1;
    public static final double OVERSHOOT_MULTIPLIER = 1.5;

    public static void main(String[] args) throws Exception {
        ToolRunner.run((Tool)new EigencutsDriver(), (String[])args);
    }

    public int run(String[] arg0) throws Exception {
        this.addOption("half-life", "b", "Minimal half-life threshold", true);
        this.addOption("dimensions", "d", "Square dimensions of affinity matrix", true);
        this.addOption("epsilon", "e", "Half-life threshold coefficient", Double.toString(0.25));
        this.addOption("tau", "t", "Threshold for cutting affinities", Double.toString(-0.1));
        this.addOption("eigenrank", "k", "Number of top eigenvectors to use", true);
        this.addOption((Option)DefaultOptionCreator.inputOption().create());
        this.addOption((Option)DefaultOptionCreator.outputOption().create());
        this.addOption((Option)DefaultOptionCreator.overwriteOption().create());
        Map<String, String> parsedArgs = this.parseArguments(arg0);
        if (parsedArgs == null) {
            return 0;
        }
        Path input = new Path(parsedArgs.get("--input"));
        Path output = new Path(parsedArgs.get("--output"));
        if (this.hasOption("overwrite")) {
            HadoopUtil.delete(this.getConf(), output);
        }
        int dimensions = Integer.parseInt(parsedArgs.get("--dimensions"));
        double halflife = Double.parseDouble(parsedArgs.get("--half-life"));
        double epsilon = Double.parseDouble(parsedArgs.get("--epsilon"));
        double tau = Double.parseDouble(parsedArgs.get("--tau"));
        int eigenrank = Integer.parseInt(parsedArgs.get("--eigenrank"));
        EigencutsDriver.run(this.getConf(), input, output, eigenrank, dimensions, halflife, epsilon, tau);
        return 0;
    }

    public static void run(Configuration conf, Path input, Path output, int dimensions, int eigenrank, double halflife, double epsilon, double tau) throws IOException, InterruptedException, ClassNotFoundException {
        long numCuts;
        Path outputCalc = new Path(output, "calculations");
        Path outputTmp = new Path(output, "temporary");
        DistributedRowMatrix A = AffinityMatrixInputJob.runJob(input, outputCalc, dimensions);
        Vector D = MatrixDiagonalizeJob.runJob(A.getRowPath(), dimensions);
        do {
            DistributedRowMatrix L = VectorMatrixMultiplicationJob.runJob(A.getRowPath(), D, new Path(outputCalc, "laplacian-" + (System.nanoTime() & 0xFFL)));
            L.setConf(new Configuration(conf));
            int overshoot = (int)((double)eigenrank * 1.5);
            LanczosState state = new LanczosState((VectorIterable)L, overshoot, eigenrank, new DistributedLanczosSolver().getInitialVector(L));
            DistributedRowMatrix U = EigencutsDriver.performEigenDecomposition(conf, L, state, eigenrank, overshoot, outputCalc);
            U.setConf(new Configuration(conf));
            ArrayList<Double> eigenValues = new ArrayList<Double>();
            for (int i = 0; i < eigenrank; ++i) {
                eigenValues.set(i, state.getSingularValue(i));
            }
            Vector evs = EigencutsDriver.listToVector(eigenValues);
            Path sensitivities = new Path(outputCalc, "sensitivities-" + (System.nanoTime() & 0xFFL));
            EigencutsSensitivityJob.runJob(evs, D, U.getRowPath(), halflife, tau, EigencutsDriver.median(D), epsilon, sensitivities);
            input = new Path(outputTmp, "nextAff-" + (System.nanoTime() & 0xFFL));
            numCuts = EigencutsAffinityCutsJob.runjob(A.getRowPath(), sensitivities, input, conf);
            if (numCuts <= 0L) continue;
            A = new DistributedRowMatrix(input, new Path(outputTmp, Long.toString(System.nanoTime())), dimensions, dimensions);
            A.setConf(new Configuration());
        } while (numCuts > 0L);
    }

    public static DistributedRowMatrix performEigenDecomposition(Configuration conf, DistributedRowMatrix input, LanczosState state, int numEigenVectors, int overshoot, Path tmp) throws IOException {
        DistributedLanczosSolver solver = new DistributedLanczosSolver();
        Path seqFiles = new Path(tmp, "eigendecomp-" + (System.nanoTime() & 0xFFL));
        solver.runJob(conf, state, overshoot, true, seqFiles.toString());
        EigenVerificationJob verifier = new EigenVerificationJob();
        Path verifiedEigens = new Path(tmp, "verifiedeigens");
        verifier.runJob(conf, seqFiles, input.getRowPath(), verifiedEigens, false, 1.0, 0.0, numEigenVectors);
        Path cleanedEigens = verifier.getCleanedEigensPath();
        return new DistributedRowMatrix(cleanedEigens, new Path(cleanedEigens, "tmp"), numEigenVectors, input.numRows());
    }

    private static double median(Vector v) {
        OnlineSummarizer med = new OnlineSummarizer();
        if (v.size() < 100) {
            return v.zSum() / (double)v.size();
        }
        for (Vector.Element e : v) {
            med.add(e.get());
        }
        return med.getMedian();
    }

    private static Vector listToVector(Collection<Double> list) {
        DenseVector retval = new DenseVector(list.size());
        int index = 0;
        for (Double d : list) {
            retval.setQuick(index++, d.doubleValue());
        }
        return retval;
    }
}

