/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.clustering.spectral.eigencuts;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.Reducer;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;
import org.apache.hadoop.mapreduce.lib.input.SequenceFileInputFormat;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;
import org.apache.hadoop.mapreduce.lib.output.SequenceFileOutputFormat;
import org.apache.mahout.clustering.spectral.common.VertexWritable;
import org.apache.mahout.math.RandomAccessSparseVector;
import org.apache.mahout.math.Vector;
import org.apache.mahout.math.VectorWritable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class EigencutsAffinityCutsJob {
    private static final Logger log = LoggerFactory.getLogger(EigencutsAffinityCutsJob.class);

    private EigencutsAffinityCutsJob() {
    }

    public static long runjob(Path currentAffinity, Path cutMatrix, Path nextAffinity, Configuration conf) throws IOException, ClassNotFoundException, InterruptedException {
        conf.set("org.apache.mahout.clustering.spectral.eigencuts.affinitypath", currentAffinity.getName());
        conf.set("org.apache.mahout.clustering.spectral.eigencuts.cutmatrixpath", cutMatrix.getName());
        Job job = new Job(conf, "EigencutsAffinityCutsJob");
        job.setInputFormatClass(SequenceFileInputFormat.class);
        job.setOutputFormatClass(SequenceFileOutputFormat.class);
        job.setMapOutputKeyClass(Text.class);
        job.setMapOutputValueClass(VertexWritable.class);
        job.setOutputKeyClass(IntWritable.class);
        job.setOutputValueClass(VectorWritable.class);
        job.setMapperClass(EigencutsAffinityCutsMapper.class);
        job.setCombinerClass(EigencutsAffinityCutsCombiner.class);
        job.setReducerClass(EigencutsAffinityCutsReducer.class);
        FileInputFormat.addInputPath((Job)job, (Path)cutMatrix);
        FileOutputFormat.setOutputPath((Job)job, (Path)nextAffinity);
        job.waitForCompletion(true);
        return job.getCounters().findCounter((Enum)CUTSCOUNTER.NUM_CUTS).getValue();
    }

    public static class EigencutsAffinityCutsReducer
    extends Reducer<Text, VertexWritable, IntWritable, VectorWritable> {
        protected void reduce(Text row, Iterable<VertexWritable> entries, Reducer.Context context) throws IOException, InterruptedException {
            RandomAccessSparseVector output = new RandomAccessSparseVector(context.getConfiguration().getInt("org.apache.mahout.clustering.spectral.eigencuts.affinitydimensions", Integer.MAX_VALUE), 100);
            int rownum = Integer.parseInt(row.toString());
            for (VertexWritable e : entries) {
                if (e.getCol() == rownum) {
                    output.setQuick(e.getCol(), output.getQuick(e.getCol()) + e.getValue());
                    continue;
                }
                output.setQuick(e.getCol(), e.getValue());
            }
            context.write((Object)new IntWritable(rownum), (Object)new VectorWritable((Vector)output));
        }
    }

    public static class EigencutsAffinityCutsCombiner
    extends Reducer<Text, VertexWritable, Text, VertexWritable> {
        protected void reduce(Text t, Iterable<VertexWritable> vertices, Reducer.Context context) throws IOException, InterruptedException {
            Configuration conf = context.getConfiguration();
            log.debug("{}", (Object)t);
            boolean zero = false;
            int i = -1;
            int j = -1;
            double k = 0.0;
            int count = 0;
            for (VertexWritable v : vertices) {
                ++count;
                if (v.getType().equals(conf.get("org.apache.mahout.clustering.spectral.eigencuts.affinitypath"))) {
                    i = v.getRow();
                    j = v.getCol();
                    k = v.getValue();
                    continue;
                }
                if (v.getValue() == 0.0) continue;
                zero = true;
            }
            if (count == 2) {
                VertexWritable vw = new VertexWritable(i, j, k, "unimportant");
                context.write((Object)new Text(String.valueOf(i)), (Object)vw);
                return;
            }
            VertexWritable outI = new VertexWritable();
            VertexWritable outJ = new VertexWritable();
            if (zero) {
                context.getCounter((Enum)CUTSCOUNTER.NUM_CUTS).increment(1L);
                outI.setCol(i);
                outJ.setCol(j);
                VertexWritable zeroI = new VertexWritable();
                VertexWritable zeroJ = new VertexWritable();
                zeroI.setCol(j);
                zeroI.setValue(0.0);
                zeroJ.setCol(i);
                zeroJ.setValue(0.0);
                zeroI.setType("unimportant");
                zeroJ.setType("unimportant");
                context.write((Object)new Text(String.valueOf(i)), (Object)zeroI);
                context.write((Object)new Text(String.valueOf(j)), (Object)zeroJ);
            } else {
                outI.setCol(j);
                outJ.setCol(i);
            }
            outI.setValue(k);
            outJ.setValue(k);
            outI.setType("unimportant");
            outJ.setType("unimportant");
            context.write((Object)new Text(String.valueOf(i)), (Object)outI);
            context.write((Object)new Text(String.valueOf(j)), (Object)outJ);
        }
    }

    public static class EigencutsAffinityCutsMapper
    extends Mapper<IntWritable, VectorWritable, Text, VertexWritable> {
        protected void map(IntWritable key, VectorWritable row, Mapper.Context context) throws IOException, InterruptedException {
            String type = context.getWorkingDirectory().getName();
            Vector vector = row.get();
            for (Vector.Element e : vector) {
                String newkey = Math.max(key.get(), e.index()) + "_" + Math.min(key.get(), e.index());
                context.write((Object)new Text(newkey), (Object)new VertexWritable(key.get(), e.index(), e.get(), type));
            }
        }
    }

    static enum CUTSCOUNTER {
        NUM_CUTS;

    }
}

