/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.clustering.spectral.common;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;
import org.apache.hadoop.mapreduce.lib.input.SequenceFileInputFormat;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;
import org.apache.hadoop.mapreduce.lib.output.SequenceFileOutputFormat;
import org.apache.mahout.clustering.spectral.common.VectorCache;
import org.apache.mahout.math.DenseVector;
import org.apache.mahout.math.Vector;
import org.apache.mahout.math.VectorWritable;
import org.apache.mahout.math.function.Functions;
import org.apache.mahout.math.hadoop.DistributedRowMatrix;

public final class VectorMatrixMultiplicationJob {
    private VectorMatrixMultiplicationJob() {
    }

    public static DistributedRowMatrix runJob(Path markovPath, Vector diag, Path outputPath) throws IOException, ClassNotFoundException, InterruptedException {
        Configuration conf = new Configuration();
        FileSystem fs = FileSystem.get((Configuration)conf);
        markovPath = fs.makeQualified(markovPath);
        outputPath = fs.makeQualified(outputPath);
        Path vectorOutputPath = new Path(outputPath.getParent(), "vector");
        VectorCache.save((Writable)new IntWritable(1), diag, vectorOutputPath, conf);
        Job job = new Job(conf, "VectorMatrixMultiplication");
        job.setInputFormatClass(SequenceFileInputFormat.class);
        job.setOutputKeyClass(IntWritable.class);
        job.setOutputValueClass(VectorWritable.class);
        job.setOutputFormatClass(SequenceFileOutputFormat.class);
        job.setMapperClass(VectorMatrixMultiplicationMapper.class);
        job.setNumReduceTasks(0);
        FileInputFormat.addInputPath((Job)job, (Path)markovPath);
        FileOutputFormat.setOutputPath((Job)job, (Path)outputPath);
        job.waitForCompletion(true);
        return new DistributedRowMatrix(outputPath, new Path(outputPath, "tmp"), diag.size(), diag.size());
    }

    public static class VectorMatrixMultiplicationMapper
    extends Mapper<IntWritable, VectorWritable, IntWritable, VectorWritable> {
        private Vector diagonal;

        protected void setup(Mapper.Context context) throws IOException, InterruptedException {
            super.setup(context);
            Configuration config = context.getConfiguration();
            this.diagonal = VectorCache.load(config);
            if (this.diagonal == null) {
                throw new IOException("No vector loaded from cache!");
            }
            if (!(this.diagonal instanceof DenseVector)) {
                this.diagonal = new DenseVector(this.diagonal);
            }
        }

        protected void map(IntWritable key, VectorWritable row, Mapper.Context ctx) throws IOException, InterruptedException {
            for (Vector.Element e : row.get()) {
                double dii = Functions.SQRT.apply(this.diagonal.get(key.get()));
                double djj = Functions.SQRT.apply(this.diagonal.get(e.index()));
                double mij = e.get();
                e.set(dii * mij * djj);
            }
            ctx.write((Object)key, (Object)row);
        }

        void setup(Vector diag) {
            this.diagonal = diag;
        }
    }
}

