/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.clustering.spectral.common;

import java.io.IOException;
import java.net.URI;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.filecache.DistributedCache;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.Writable;
import org.apache.mahout.common.HadoopUtil;
import org.apache.mahout.common.iterator.sequencefile.SequenceFileValueIterator;
import org.apache.mahout.math.Vector;
import org.apache.mahout.math.VectorWritable;

public final class VectorCache {
    private VectorCache() {
    }

    public static void save(Writable key, Vector vector, Path output, Configuration conf, boolean overwritePath, boolean deleteOnExit) throws IOException {
        FileSystem fs = FileSystem.get((Configuration)conf);
        output = fs.makeQualified(output);
        if (overwritePath) {
            HadoopUtil.delete(conf, output);
        }
        DistributedCache.setCacheFiles((URI[])new URI[]{output.toUri()}, (Configuration)conf);
        SequenceFile.Writer writer = new SequenceFile.Writer(fs, conf, output, IntWritable.class, VectorWritable.class);
        writer.append(key, (Writable)new VectorWritable(vector));
        writer.close();
        if (deleteOnExit) {
            fs.deleteOnExit(output);
        }
    }

    public static void save(Writable key, Vector vector, Path output, Configuration conf) throws IOException {
        VectorCache.save(key, vector, output, conf, true, true);
    }

    public static Vector load(Configuration conf) throws IOException {
        URI[] files = DistributedCache.getCacheFiles((Configuration)conf);
        if (files == null || files.length < 1) {
            return null;
        }
        return VectorCache.load(conf, new Path(files[0].getPath()));
    }

    public static Vector load(Configuration conf, Path input) throws IOException {
        SequenceFileValueIterator iterator = new SequenceFileValueIterator(input, true, conf);
        VectorWritable vectorWritable = (VectorWritable)((Object)iterator.next());
        iterator.close();
        return vectorWritable.get();
    }
}

