/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.clustering.spectral.common;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;
import org.apache.hadoop.mapreduce.lib.input.SequenceFileInputFormat;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;
import org.apache.hadoop.mapreduce.lib.output.SequenceFileOutputFormat;
import org.apache.mahout.math.RandomAccessSparseVector;
import org.apache.mahout.math.Vector;
import org.apache.mahout.math.VectorWritable;
import org.apache.mahout.math.function.Functions;

public final class UnitVectorizerJob {
    private UnitVectorizerJob() {
    }

    public static void runJob(Path input, Path output) throws IOException, InterruptedException, ClassNotFoundException {
        Configuration conf = new Configuration();
        Job job = new Job(conf, "UnitVectorizerJob");
        job.setInputFormatClass(SequenceFileInputFormat.class);
        job.setOutputKeyClass(IntWritable.class);
        job.setOutputValueClass(VectorWritable.class);
        job.setOutputFormatClass(SequenceFileOutputFormat.class);
        job.setMapperClass(UnitVectorizerMapper.class);
        job.setNumReduceTasks(0);
        FileInputFormat.addInputPath((Job)job, (Path)input);
        FileOutputFormat.setOutputPath((Job)job, (Path)output);
        job.waitForCompletion(true);
    }

    public static class UnitVectorizerMapper
    extends Mapper<IntWritable, VectorWritable, IntWritable, VectorWritable> {
        protected void map(IntWritable row, VectorWritable vector, Mapper.Context context) throws IOException, InterruptedException {
            double norm = UnitVectorizerMapper.vectorNorm((Iterable<Vector.Element>)vector.get());
            Vector w = vector.get().assign(Functions.div((double)norm));
            RandomAccessSparseVector out = new RandomAccessSparseVector(w);
            context.write((Object)row, (Object)new VectorWritable((Vector)out));
        }

        private static double vectorNorm(Iterable<Vector.Element> u) {
            double retval = 0.0;
            for (Vector.Element e : u) {
                retval += Functions.POW.apply(e.get(), 2.0);
            }
            return Functions.SQRT.apply(retval);
        }
    }
}

