/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.clustering.spectral.common;

import java.io.IOException;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.mapreduce.Reducer;
import org.apache.mahout.math.RandomAccessSparseVector;
import org.apache.mahout.math.SequentialAccessSparseVector;
import org.apache.mahout.math.Vector;
import org.apache.mahout.math.VectorWritable;
import org.apache.mahout.math.hadoop.DistributedRowMatrix;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AffinityMatrixInputReducer
extends Reducer<IntWritable, DistributedRowMatrix.MatrixEntryWritable, IntWritable, VectorWritable> {
    private static final Logger log = LoggerFactory.getLogger(AffinityMatrixInputReducer.class);

    protected void reduce(IntWritable row, Iterable<DistributedRowMatrix.MatrixEntryWritable> values, Reducer.Context context) throws IOException, InterruptedException {
        int size = context.getConfiguration().getInt("org.apache.mahout.clustering.spectral.eigencuts.affinitydimensions", Integer.MAX_VALUE);
        RandomAccessSparseVector out = new RandomAccessSparseVector(size, 100);
        for (DistributedRowMatrix.MatrixEntryWritable element : values) {
            out.setQuick(element.getCol(), element.getVal());
            if (!log.isDebugEnabled()) continue;
            log.debug("(DEBUG - REDUCE) Row[{}], Column[{}], Value[{}]", new Object[]{row.get(), element.getCol(), element.getVal()});
        }
        SequentialAccessSparseVector output = new SequentialAccessSparseVector((Vector)out);
        context.write((Object)row, (Object)new VectorWritable((Vector)output));
    }
}

