/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.clustering.spectral.common;

import java.io.IOException;
import java.util.regex.Pattern;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.mahout.math.hadoop.DistributedRowMatrix;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AffinityMatrixInputMapper
extends Mapper<LongWritable, Text, IntWritable, DistributedRowMatrix.MatrixEntryWritable> {
    private static final Logger log = LoggerFactory.getLogger(AffinityMatrixInputMapper.class);
    private static final Pattern COMMA_PATTERN = Pattern.compile(",");

    protected void map(LongWritable key, Text value, Mapper.Context context) throws IOException, InterruptedException {
        String[] elements = COMMA_PATTERN.split(value.toString());
        log.debug("(DEBUG - MAP) Key[{}], Value[{}]", (Object)key.get(), (Object)value);
        if (elements.length != 3) {
            throw new IOException("Expected input of length 3, received " + elements.length + ". Please make sure you adhere to " + "the structure of (i,j,value) for representing a graph in text.");
        }
        if (elements[0].length() == 0 || elements[1].length() == 0 || elements[2].length() == 0) {
            throw new IOException("Found an element of 0 length. Please be sure you adhere to the structure of (i,j,value) for  representing a graph in text.");
        }
        DistributedRowMatrix.MatrixEntryWritable toAdd = new DistributedRowMatrix.MatrixEntryWritable();
        IntWritable row = new IntWritable(Integer.valueOf(elements[0]).intValue());
        toAdd.setRow(-1);
        toAdd.setCol(Integer.valueOf(elements[1]));
        toAdd.setVal(Double.valueOf(elements[2]));
        context.write((Object)row, (Object)toAdd);
    }
}

