/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.clustering.spectral.common;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;
import org.apache.hadoop.mapreduce.lib.output.SequenceFileOutputFormat;
import org.apache.mahout.clustering.spectral.common.AffinityMatrixInputMapper;
import org.apache.mahout.clustering.spectral.common.AffinityMatrixInputReducer;
import org.apache.mahout.common.HadoopUtil;
import org.apache.mahout.math.VectorWritable;
import org.apache.mahout.math.hadoop.DistributedRowMatrix;

public final class AffinityMatrixInputJob {
    private AffinityMatrixInputJob() {
    }

    public static void runJob(Path input, Path output, int rows, int cols) throws IOException, InterruptedException, ClassNotFoundException {
        Configuration conf = new Configuration();
        HadoopUtil.delete(conf, output);
        conf.setInt("org.apache.mahout.clustering.spectral.eigencuts.affinitydimensions", rows);
        Job job = new Job(conf, "AffinityMatrixInputJob: " + input + " -> M/R -> " + output);
        job.setMapOutputKeyClass(IntWritable.class);
        job.setMapOutputValueClass(DistributedRowMatrix.MatrixEntryWritable.class);
        job.setOutputKeyClass(IntWritable.class);
        job.setOutputValueClass(VectorWritable.class);
        job.setOutputFormatClass(SequenceFileOutputFormat.class);
        job.setMapperClass(AffinityMatrixInputMapper.class);
        job.setReducerClass(AffinityMatrixInputReducer.class);
        FileInputFormat.addInputPath((Job)job, (Path)input);
        FileOutputFormat.setOutputPath((Job)job, (Path)output);
        job.waitForCompletion(true);
    }

    public static DistributedRowMatrix runJob(Path input, Path output, int dimensions) throws IOException, InterruptedException, ClassNotFoundException {
        Path seqFiles = new Path(output, "seqfiles-" + (System.nanoTime() & 0xFFL));
        AffinityMatrixInputJob.runJob(input, seqFiles, dimensions, dimensions);
        DistributedRowMatrix a = new DistributedRowMatrix(seqFiles, new Path(seqFiles, "seqtmp-" + (System.nanoTime() & 0xFFL)), dimensions, dimensions);
        a.setConf(new Configuration());
        return a;
    }
}

