/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.clustering.minhash;

import java.io.IOException;
import java.util.ArrayList;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapreduce.Reducer;
import org.apache.mahout.math.Vector;
import org.apache.mahout.math.VectorWritable;

public class MinHashReducer
extends Reducer<Text, Writable, Text, Writable> {
    private int minClusterSize;
    private boolean debugOutput;

    protected void setup(Reducer.Context context) throws IOException, InterruptedException {
        super.setup(context);
        Configuration conf = context.getConfiguration();
        this.minClusterSize = conf.getInt("minClusterSize", 5);
        this.debugOutput = conf.getBoolean("debugOutput", false);
    }

    protected void reduce(Text cluster, Iterable<Writable> points, Reducer.Context context) throws IOException, InterruptedException {
        ArrayList<VectorWritable> pointList = new ArrayList<VectorWritable>();
        for (Writable writable : points) {
            if (this.debugOutput) {
                Vector pointVector = ((VectorWritable)writable).get().clone();
                VectorWritable writablePointVector = new VectorWritable(pointVector);
                pointList.add(writablePointVector);
                continue;
            }
            Text pointText = new Text(writable.toString());
            pointList.add((VectorWritable)pointText);
        }
        if (pointList.size() >= this.minClusterSize) {
            context.getCounter((Enum)Clusters.ACCEPTED).increment(1L);
            for (Writable writable : pointList) {
                context.write((Object)cluster, (Object)writable);
            }
        } else {
            context.getCounter((Enum)Clusters.DISCARDED).increment(1L);
        }
    }

    static enum Clusters {
        ACCEPTED,
        DISCARDED;

    }
}

