/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.clustering.minhash;

import java.io.IOException;
import org.apache.commons.cli2.Option;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;
import org.apache.hadoop.mapreduce.lib.input.SequenceFileInputFormat;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;
import org.apache.hadoop.mapreduce.lib.output.SequenceFileOutputFormat;
import org.apache.hadoop.mapreduce.lib.output.TextOutputFormat;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.apache.mahout.clustering.minhash.MinHashMapper;
import org.apache.mahout.clustering.minhash.MinHashReducer;
import org.apache.mahout.common.AbstractJob;
import org.apache.mahout.common.commandline.MinhashOptionCreator;
import org.apache.mahout.math.VectorWritable;

public final class MinHashDriver
extends AbstractJob {
    public static void main(String[] args) throws Exception {
        ToolRunner.run((Configuration)new Configuration(), (Tool)new MinHashDriver(), (String[])args);
    }

    private void runJob(Path input, Path output, int minClusterSize, int minVectorSize, String hashType, int numHashFunctions, int keyGroups, int numReduceTasks, boolean debugOutput) throws IOException, ClassNotFoundException, InterruptedException {
        Configuration conf = this.getConf();
        conf.setInt("minClusterSize", minClusterSize);
        conf.setInt("minVectorSize", minVectorSize);
        conf.set("hashType", hashType);
        conf.setInt("numHashFunctions", numHashFunctions);
        conf.setInt("keyGroups", keyGroups);
        conf.setBoolean("debugOutput", debugOutput);
        Class outputClass = debugOutput ? VectorWritable.class : Text.class;
        Class outputFormatClass = debugOutput ? SequenceFileOutputFormat.class : TextOutputFormat.class;
        Job job = new Job(conf, "MinHash Clustering");
        job.setJarByClass(MinHashDriver.class);
        FileInputFormat.setInputPaths((Job)job, (Path[])new Path[]{input});
        FileOutputFormat.setOutputPath((Job)job, (Path)output);
        job.setMapperClass(MinHashMapper.class);
        job.setReducerClass(MinHashReducer.class);
        job.setInputFormatClass(SequenceFileInputFormat.class);
        job.setOutputFormatClass(outputFormatClass);
        job.setMapOutputKeyClass(Text.class);
        job.setMapOutputValueClass(outputClass);
        job.setOutputKeyClass(Text.class);
        job.setOutputValueClass(outputClass);
        job.setNumReduceTasks(numReduceTasks);
        job.waitForCompletion(true);
    }

    public int run(String[] args) throws IOException, ClassNotFoundException, InterruptedException {
        this.addInputOption();
        this.addOutputOption();
        this.addOption((Option)MinhashOptionCreator.minClusterSizeOption().create());
        this.addOption((Option)MinhashOptionCreator.minVectorSizeOption().create());
        this.addOption((Option)MinhashOptionCreator.hashTypeOption().create());
        this.addOption((Option)MinhashOptionCreator.numHashFunctionsOption().create());
        this.addOption((Option)MinhashOptionCreator.keyGroupsOption().create());
        this.addOption((Option)MinhashOptionCreator.numReducersOption().create());
        this.addOption((Option)MinhashOptionCreator.debugOutputOption().create());
        if (this.parseArguments(args) == null) {
            return -1;
        }
        Path input = this.getInputPath();
        Path output = this.getOutputPath();
        int minClusterSize = Integer.valueOf(this.getOption("minClusterSize"));
        int minVectorSize = Integer.valueOf(this.getOption("minVectorSize"));
        String hashType = this.getOption("hashType");
        int numHashFunctions = Integer.valueOf(this.getOption("numHashFunctions"));
        int keyGroups = Integer.valueOf(this.getOption("keyGroups"));
        int numReduceTasks = Integer.parseInt(this.getOption("numReducers"));
        boolean debugOutput = Boolean.parseBoolean(this.getOption("debugOutput"));
        this.runJob(input, output, minClusterSize, minVectorSize, hashType, numHashFunctions, keyGroups, numReduceTasks, debugOutput);
        return 0;
    }
}

