/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.clustering.minhash;

import java.util.Random;
import org.apache.mahout.clustering.minhash.HashFunction;
import org.apache.mahout.common.RandomUtils;
import org.apache.mahout.vectorizer.encoders.MurmurHash;

public final class HashFactory {
    private HashFactory() {
    }

    public static HashFunction[] createHashFunctions(HashType type, int numFunctions) {
        HashFunction[] hashFunction = new HashFunction[numFunctions];
        Random seed = RandomUtils.getRandom((long)11L);
        switch (type) {
            case LINEAR: {
                for (int i = 0; i < numFunctions; ++i) {
                    hashFunction[i] = new LinearHash(seed.nextInt(), seed.nextInt());
                }
                break;
            }
            case POLYNOMIAL: {
                for (int i = 0; i < numFunctions; ++i) {
                    hashFunction[i] = new PolynomialHash(seed.nextInt(), seed.nextInt(), seed.nextInt());
                }
                break;
            }
            case MURMUR: {
                for (int i = 0; i < numFunctions; ++i) {
                    hashFunction[i] = new MurmurHashWrapper(seed.nextInt());
                }
                break;
            }
            default: {
                throw new IllegalStateException("Unknown type: " + (Object)((Object)type));
            }
        }
        return hashFunction;
    }

    static class MurmurHashWrapper
    implements HashFunction {
        private final int seed;

        MurmurHashWrapper(int seed) {
            this.seed = seed;
        }

        @Override
        public int hash(byte[] bytes) {
            long hashValue = MurmurHash.hash64A(bytes, this.seed);
            return Math.abs((int)(hashValue % 2147482949L));
        }
    }

    static class PolynomialHash
    implements HashFunction {
        private final int seedA;
        private final int seedB;
        private final int seedC;

        PolynomialHash(int seedA, int seedB, int seedC) {
            this.seedA = seedA;
            this.seedB = seedB;
            this.seedC = seedC;
        }

        @Override
        public int hash(byte[] bytes) {
            long hashValue = 31L;
            byte[] arr$ = bytes;
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$; ++i$) {
                long byteVal = arr$[i$];
                hashValue *= (long)this.seedA * (byteVal >> 4);
                hashValue += (long)this.seedB * byteVal + (long)this.seedC;
            }
            return Math.abs((int)(hashValue % 2147482949L));
        }
    }

    static class LinearHash
    implements HashFunction {
        private final int seedA;
        private final int seedB;

        LinearHash(int seedA, int seedB) {
            this.seedA = seedA;
            this.seedB = seedB;
        }

        @Override
        public int hash(byte[] bytes) {
            long hashValue = 31L;
            byte[] arr$ = bytes;
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$; ++i$) {
                long byteVal = arr$[i$];
                hashValue *= (long)this.seedA * byteVal;
                hashValue += (long)this.seedB;
            }
            return Math.abs((int)(hashValue % 2147482949L));
        }
    }

    public static enum HashType {
        LINEAR,
        POLYNOMIAL,
        MURMUR;

    }
}

