/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.clustering.meanshift;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Reducer;
import org.apache.mahout.clustering.meanshift.MeanShiftCanopy;
import org.apache.mahout.clustering.meanshift.MeanShiftCanopyClusterer;

public class MeanShiftCanopyReducer
extends Reducer<Text, MeanShiftCanopy, Text, MeanShiftCanopy> {
    private final Collection<MeanShiftCanopy> canopies = new ArrayList<MeanShiftCanopy>();
    private MeanShiftCanopyClusterer clusterer;
    private boolean allConverged = true;

    protected void setup(Reducer.Context context) throws IOException, InterruptedException {
        super.setup(context);
        this.clusterer = new MeanShiftCanopyClusterer(context.getConfiguration());
    }

    protected void reduce(Text key, Iterable<MeanShiftCanopy> values, Reducer.Context context) throws IOException, InterruptedException {
        for (MeanShiftCanopy value : values) {
            this.clusterer.mergeCanopy(value.shallowCopy(), this.canopies);
        }
        for (MeanShiftCanopy canopy : this.canopies) {
            boolean converged = this.clusterer.shiftToMean(canopy);
            if (converged) {
                context.getCounter("Clustering", "Converged Clusters").increment(1L);
            }
            this.allConverged = converged && this.allConverged;
            context.write((Object)new Text(canopy.getIdentifier()), (Object)canopy);
        }
    }

    protected void cleanup(Reducer.Context context) throws IOException, InterruptedException {
        Configuration conf = context.getConfiguration();
        if (this.allConverged) {
            Path path = new Path(conf.get("org.apache.mahout.clustering.control.path"));
            FileSystem.get((Configuration)conf).createNewFile(path);
        }
        super.cleanup(context);
    }
}

