/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.clustering.meanshift;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.mahout.clustering.meanshift.MeanShiftCanopy;
import org.apache.mahout.clustering.meanshift.MeanShiftCanopyClusterer;

public class MeanShiftCanopyMapper
extends Mapper<WritableComparable<?>, MeanShiftCanopy, Text, MeanShiftCanopy> {
    private final Collection<MeanShiftCanopy> canopies = new ArrayList<MeanShiftCanopy>();
    private MeanShiftCanopyClusterer clusterer;

    protected void setup(Mapper.Context context) throws IOException, InterruptedException {
        super.setup(context);
        this.clusterer = new MeanShiftCanopyClusterer(context.getConfiguration());
    }

    protected void map(WritableComparable<?> key, MeanShiftCanopy canopy, Mapper.Context context) throws IOException, InterruptedException {
        this.clusterer.mergeCanopy(canopy.shallowCopy(), this.canopies);
    }

    protected void cleanup(Mapper.Context context) throws IOException, InterruptedException {
        for (MeanShiftCanopy canopy : this.canopies) {
            this.clusterer.shiftToMean(canopy);
            context.write((Object)new Text("canopy"), (Object)canopy);
        }
        super.cleanup(context);
    }
}

