/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.clustering.meanshift;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.regex.Pattern;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.mahout.clustering.meanshift.MeanShiftCanopy;
import org.apache.mahout.common.distance.DistanceMeasure;
import org.apache.mahout.math.VectorWritable;

public class MeanShiftCanopyCreatorMapper
extends Mapper<WritableComparable<?>, VectorWritable, Text, MeanShiftCanopy> {
    private static final Pattern UNDERSCORE_PATTERN = Pattern.compile("_");
    private static int nextCanopyId = -1;
    private DistanceMeasure measure;

    protected void map(WritableComparable<?> key, VectorWritable point, Mapper.Context context) throws IOException, InterruptedException {
        MeanShiftCanopy canopy = MeanShiftCanopy.initialCanopy(point.get(), nextCanopyId++, this.measure);
        context.write((Object)new Text(key.toString()), (Object)canopy);
    }

    protected void setup(Mapper.Context context) throws IOException, InterruptedException {
        super.setup(context);
        String measureClass = context.getConfiguration().get("org.apache.mahout.clustering.kmeans.measure");
        ClassLoader ccl = Thread.currentThread().getContextClassLoader();
        try {
            this.measure = ccl.loadClass(measureClass).asSubclass(DistanceMeasure.class).newInstance();
        }
        catch (InstantiationException e) {
            throw new IllegalStateException(e);
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException(e);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException(e);
        }
        if (nextCanopyId == -1) {
            String taskId = context.getConfiguration().get("mapred.task.id");
            String[] parts = UNDERSCORE_PATTERN.split(taskId);
            Preconditions.checkArgument((parts.length == 6 && "attempt".equals(parts[0]) && ("m".equals(parts[3]) || "r".equals(parts[3])) ? 1 : 0) != 0, (String)"TaskAttemptId string: %d is not properly formed", (Object[])new Object[]{taskId});
            nextCanopyId = -42949 * Integer.parseInt(parts[4]);
        }
    }
}

