/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.clustering.meanshift;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.mahout.clustering.meanshift.MeanShiftCanopy;
import org.apache.mahout.common.distance.DistanceMeasure;
import org.apache.mahout.math.Vector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MeanShiftCanopyClusterer {
    private static final Logger log = LoggerFactory.getLogger(MeanShiftCanopyClusterer.class);
    private final double convergenceDelta;
    private final double t1;
    private final double t2;
    private final DistanceMeasure measure;

    public MeanShiftCanopyClusterer(Configuration configuration) {
        try {
            this.measure = Class.forName(configuration.get("org.apache.mahout.clustering.canopy.measure")).asSubclass(DistanceMeasure.class).newInstance();
            this.measure.configure(configuration);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException(e);
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException(e);
        }
        catch (InstantiationException e) {
            throw new IllegalStateException(e);
        }
        this.t1 = Double.parseDouble(configuration.get("org.apache.mahout.clustering.canopy.t1"));
        this.t2 = Double.parseDouble(configuration.get("org.apache.mahout.clustering.canopy.t2"));
        this.convergenceDelta = Double.parseDouble(configuration.get("org.apache.mahout.clustering.canopy.convergence"));
    }

    public MeanShiftCanopyClusterer(DistanceMeasure aMeasure, double aT1, double aT2, double aDelta) {
        this.measure = aMeasure;
        this.t1 = aT1;
        this.t2 = aT2;
        this.convergenceDelta = aDelta;
    }

    public double getT1() {
        return this.t1;
    }

    public double getT2() {
        return this.t2;
    }

    public void mergeCanopy(MeanShiftCanopy aCanopy, Collection<MeanShiftCanopy> canopies) {
        MeanShiftCanopy closestCoveringCanopy = null;
        double closestNorm = Double.MAX_VALUE;
        for (MeanShiftCanopy canopy : canopies) {
            double norm = this.measure.distance(canopy.getCenter(), aCanopy.getCenter());
            if (norm < this.t1) {
                aCanopy.touch(canopy);
            }
            if (!(norm < this.t2) || closestCoveringCanopy != null && !(norm < closestNorm)) continue;
            closestNorm = norm;
            closestCoveringCanopy = canopy;
        }
        if (closestCoveringCanopy == null) {
            canopies.add(aCanopy);
        } else {
            closestCoveringCanopy.merge(aCanopy);
        }
    }

    public boolean shiftToMean(MeanShiftCanopy canopy) {
        canopy.computeConvergence(this.measure, this.convergenceDelta);
        canopy.computeParameters();
        return canopy.isConverged();
    }

    boolean covers(MeanShiftCanopy canopy, Vector point) {
        return this.measure.distance(canopy.getCenter(), point) < this.t1;
    }

    public boolean closelyBound(MeanShiftCanopy canopy, Vector point) {
        return this.measure.distance(canopy.getCenter(), point) < this.t2;
    }

    public static List<MeanShiftCanopy> clusterPoints(Iterable<Vector> points, DistanceMeasure measure, double convergenceThreshold, double t1, double t2, int numIter) {
        MeanShiftCanopyClusterer clusterer = new MeanShiftCanopyClusterer(measure, t1, t2, convergenceThreshold);
        int nextCanopyId = 0;
        ArrayList<MeanShiftCanopy> canopies = new ArrayList<MeanShiftCanopy>();
        for (Vector point : points) {
            clusterer.mergeCanopy(new MeanShiftCanopy(point, nextCanopyId++, measure), canopies);
        }
        List<MeanShiftCanopy> newCanopies = canopies;
        boolean[] converged = new boolean[]{false};
        for (int iter = 0; !converged[0] && iter < numIter; ++iter) {
            newCanopies = clusterer.iterate(newCanopies, converged);
        }
        return newCanopies;
    }

    protected List<MeanShiftCanopy> iterate(Iterable<MeanShiftCanopy> canopies, boolean[] converged) {
        converged[0] = true;
        ArrayList<MeanShiftCanopy> migratedCanopies = new ArrayList<MeanShiftCanopy>();
        for (MeanShiftCanopy canopy : canopies) {
            converged[0] = this.shiftToMean(canopy) && converged[0];
            this.mergeCanopy(canopy, migratedCanopies);
        }
        return migratedCanopies;
    }

    protected static void verifyNonOverlap(Iterable<MeanShiftCanopy> canopies) {
        HashSet<Integer> coveredPoints = new HashSet<Integer>();
        for (MeanShiftCanopy canopy : canopies) {
            Iterator i$ = canopy.getBoundPoints().toList().iterator();
            while (i$.hasNext()) {
                int v = (Integer)i$.next();
                if (coveredPoints.contains(v)) {
                    log.info("Duplicate bound point: {} in Canopy: {}", (Object)v, (Object)canopy.asFormatString(null));
                    continue;
                }
                coveredPoints.add(v);
            }
        }
    }

    protected static MeanShiftCanopy findCoveringCanopy(MeanShiftCanopy canopy, Iterable<MeanShiftCanopy> clusters) {
        int vectorId = canopy.getId();
        for (MeanShiftCanopy msc : clusters) {
            Iterator i$ = msc.getBoundPoints().toList().iterator();
            while (i$.hasNext()) {
                int containedId = (Integer)i$.next();
                if (vectorId != containedId) continue;
                return msc;
            }
        }
        return null;
    }
}

