/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.clustering.meanshift;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.mahout.clustering.WeightedVectorWritable;
import org.apache.mahout.clustering.meanshift.MeanShiftCanopy;
import org.apache.mahout.common.iterator.sequencefile.PathFilters;
import org.apache.mahout.common.iterator.sequencefile.PathType;
import org.apache.mahout.common.iterator.sequencefile.SequenceFileDirValueIterable;

public class MeanShiftCanopyClusterMapper
extends Mapper<WritableComparable<?>, MeanShiftCanopy, IntWritable, WeightedVectorWritable> {
    private List<MeanShiftCanopy> canopies;

    protected void map(WritableComparable<?> key, MeanShiftCanopy canopy, Mapper.Context context) throws IOException, InterruptedException {
        int vectorId = canopy.getId();
        for (MeanShiftCanopy msc : this.canopies) {
            Iterator i$ = msc.getBoundPoints().toList().iterator();
            while (i$.hasNext()) {
                int containedId = (Integer)i$.next();
                if (vectorId != containedId) continue;
                context.write((Object)new IntWritable(msc.getId()), (Object)new WeightedVectorWritable(1.0, canopy.getCenter()));
            }
        }
    }

    protected void setup(Mapper.Context context) throws IOException, InterruptedException {
        super.setup(context);
        this.canopies = MeanShiftCanopyClusterMapper.getCanopies(context.getConfiguration());
    }

    public static List<MeanShiftCanopy> getCanopies(Configuration conf) {
        String statePath = conf.get("org.apache.mahout.clustering.meanshift.stateInKey");
        ArrayList<MeanShiftCanopy> canopies = new ArrayList<MeanShiftCanopy>();
        Path path = new Path(statePath);
        for (MeanShiftCanopy value : new SequenceFileDirValueIterable(path, PathType.LIST, PathFilters.logsCRCFilter(), conf)) {
            canopies.add(value);
        }
        return canopies;
    }
}

