/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.clustering.meanshift;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.commons.lang.NotImplementedException;
import org.apache.mahout.clustering.kmeans.Cluster;
import org.apache.mahout.common.distance.DistanceMeasure;
import org.apache.mahout.math.Vector;
import org.apache.mahout.math.VectorWritable;
import org.apache.mahout.math.list.IntArrayList;

public class MeanShiftCanopy
extends Cluster {
    private IntArrayList boundPoints = new IntArrayList();

    public MeanShiftCanopy() {
    }

    public MeanShiftCanopy(Vector point, int id, DistanceMeasure measure) {
        super(point, id, measure);
        this.boundPoints.add(id);
    }

    public static MeanShiftCanopy initialCanopy(Vector point, int id, DistanceMeasure measure) {
        MeanShiftCanopy result = new MeanShiftCanopy(point, id, measure);
        result.setCenter(point);
        return result;
    }

    MeanShiftCanopy(Vector point, int id, IntArrayList boundPoints, boolean converged) {
        this.setId(id);
        this.setCenter(point);
        this.setRadius(point.like());
        this.setNumPoints(1L);
        this.boundPoints = boundPoints;
        this.setConverged(converged);
    }

    public IntArrayList getBoundPoints() {
        return this.boundPoints;
    }

    void merge(MeanShiftCanopy canopy) {
        this.boundPoints.addAllOf(canopy.boundPoints);
    }

    void touch(MeanShiftCanopy canopy) {
        canopy.observe(this.getCenter(), (double)this.boundPoints.size());
        this.observe(canopy.getCenter(), (double)canopy.boundPoints.size());
    }

    @Override
    public void readFields(DataInput in) throws IOException {
        super.readFields(in);
        int numpoints = in.readInt();
        this.boundPoints = new IntArrayList();
        for (int i = 0; i < numpoints; ++i) {
            this.boundPoints.add(in.readInt());
        }
    }

    @Override
    public void write(DataOutput out) throws IOException {
        super.write(out);
        out.writeInt(this.boundPoints.size());
        for (int v : this.boundPoints.elements()) {
            out.writeInt(v);
        }
    }

    public MeanShiftCanopy shallowCopy() {
        MeanShiftCanopy result = new MeanShiftCanopy();
        result.setMeasure(this.getMeasure());
        result.setId(this.getId());
        result.setCenter(this.getCenter());
        result.setRadius(this.getRadius());
        result.setNumPoints(this.getNumPoints());
        result.setBoundPoints(this.boundPoints);
        return result;
    }

    @Override
    public String asFormatString() {
        return this.toString();
    }

    public void setBoundPoints(IntArrayList boundPoints) {
        this.boundPoints = boundPoints;
    }

    @Override
    public String getIdentifier() {
        return (this.isConverged() ? "MSV-" : "MSC-") + this.getId();
    }

    @Override
    public double pdf(VectorWritable vw) {
        throw new NotImplementedException();
    }
}

