/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.clustering.lda;

import java.io.IOException;
import java.util.Arrays;
import java.util.Iterator;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.DoubleWritable;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.mahout.clustering.lda.LDADriver;
import org.apache.mahout.clustering.lda.LDAInference;
import org.apache.mahout.clustering.lda.LDAState;
import org.apache.mahout.clustering.lda.LDAUtil;
import org.apache.mahout.common.IntPairWritable;
import org.apache.mahout.math.Vector;
import org.apache.mahout.math.VectorWritable;

public class LDAWordTopicMapper
extends Mapper<WritableComparable<?>, VectorWritable, IntPairWritable, DoubleWritable> {
    private LDAState state;
    private LDAInference infer;

    protected void map(WritableComparable<?> key, VectorWritable wordCountsWritable, Mapper.Context context) throws IOException, InterruptedException {
        LDAInference.InferredDocument doc;
        Vector wordCounts = wordCountsWritable.get();
        try {
            doc = this.infer.infer(wordCounts);
        }
        catch (ArrayIndexOutOfBoundsException e1) {
            throw new IllegalStateException("This is probably because the --numWords argument is set too small.  \n\tIt needs to be >= than the number of words (terms actually) in the corpus and can be \n\tlarger if some storage inefficiency can be tolerated.", e1);
        }
        double[] logTotals = new double[this.state.getNumTopics()];
        Arrays.fill(logTotals, Double.NEGATIVE_INFINITY);
        DoubleWritable v = new DoubleWritable();
        Iterator iter = wordCounts.iterateNonZero();
        while (iter.hasNext()) {
            Vector.Element e = (Vector.Element)iter.next();
            int w = e.index();
            for (int k = 0; k < this.state.getNumTopics(); ++k) {
                v.set(doc.phi(k, w) + Math.log(e.get()));
                IntPairWritable kw = new IntPairWritable(k, w);
                context.write((Object)kw, (Object)v);
                logTotals[k] = LDAUtil.logSum(logTotals[k], v.get());
            }
        }
        for (int k = 0; k < this.state.getNumTopics(); ++k) {
            IntPairWritable kw = new IntPairWritable(k, -1);
            v.set(logTotals[k]);
            assert (!Double.isNaN(v.get()));
            context.write((Object)kw, (Object)v);
        }
        IntPairWritable llk = new IntPairWritable(-2, -2);
        v.set(doc.getLogLikelihood());
        context.write((Object)llk, (Object)v);
    }

    public void configure(LDAState myState) {
        this.state = myState;
        this.infer = new LDAInference(this.state);
    }

    public void configure(Configuration job) {
        LDAState myState = LDADriver.createState(job);
        this.configure(myState);
    }

    protected void setup(Mapper.Context context) {
        this.configure(context.getConfiguration());
    }
}

