/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.clustering.lda;

import org.apache.mahout.clustering.lda.LDAUtil;
import org.apache.mahout.math.Matrix;

public class LDAState {
    private final int numTopics;
    private final int numWords;
    private final double topicSmoothing;
    private final Matrix topicWordProbabilities;
    private final double[] logTotals;
    private double logLikelihood;

    public LDAState(int numTopics, int numWords, double topicSmoothing, Matrix topicWordProbabilities, double[] logTotals, double ll) {
        this.numWords = numWords;
        this.numTopics = numTopics;
        this.topicSmoothing = topicSmoothing;
        this.topicWordProbabilities = topicWordProbabilities;
        this.logTotals = logTotals;
        this.logLikelihood = ll;
    }

    public double logProbWordGivenTopic(int word, int topic) {
        double logProb = this.topicWordProbabilities.get(topic, word);
        return logProb == Double.NEGATIVE_INFINITY ? -100.0 : logProb - this.logTotals[topic];
    }

    public double getLogTotal(int topic) {
        return this.logTotals[topic];
    }

    public int getNumTopics() {
        return this.numTopics;
    }

    public int getNumWords() {
        return this.numWords;
    }

    public double getTopicSmoothing() {
        return this.topicSmoothing;
    }

    public double getLogLikelihood() {
        return this.logLikelihood;
    }

    public void updateLogProbGivenTopic(int word, int topic, double logProbGivenTopic) {
        this.topicWordProbabilities.set(topic, word, LDAUtil.logSum(logProbGivenTopic, this.topicWordProbabilities.getQuick(topic, word)));
    }

    public void updateLogTotals(int topic, double logTotal) {
        this.logTotals[topic] = LDAUtil.logSum(this.logTotals[topic], logTotal);
    }

    public void setLogLikelihood(double logLikelihood) {
        this.logLikelihood = logLikelihood;
    }
}

