/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.clustering.lda;

import com.google.common.base.Preconditions;
import java.io.IOException;
import org.apache.hadoop.io.DoubleWritable;
import org.apache.hadoop.mapreduce.Reducer;
import org.apache.mahout.clustering.lda.LDAUtil;
import org.apache.mahout.common.IntPairWritable;

public class LDAReducer
extends Reducer<IntPairWritable, DoubleWritable, IntPairWritable, DoubleWritable> {
    public void reduce(IntPairWritable topicWord, Iterable<DoubleWritable> values, Reducer.Context context) throws IOException, InterruptedException {
        if (topicWord.getSecond() == -2) {
            double accum = 0.0;
            for (DoubleWritable vw : values) {
                double v = vw.get();
                Preconditions.checkArgument((!Double.isNaN(v) ? 1 : 0) != 0, (String)"Found NaN for topic=(%d,%d)", (Object[])new Object[]{topicWord.getFirst(), topicWord.getSecond()});
                accum += v;
            }
            context.write((Object)topicWord, (Object)new DoubleWritable(accum));
        } else {
            double accum = Double.NEGATIVE_INFINITY;
            for (DoubleWritable vw : values) {
                double v = vw.get();
                Preconditions.checkArgument((!Double.isNaN(v) ? 1 : 0) != 0, (String)"Found NaN for topic = (%d,%d)", (Object[])new Object[]{topicWord.getFirst(), topicWord.getSecond()});
                accum = LDAUtil.logSum(accum, v);
                Preconditions.checkArgument((!Double.isNaN(accum) ? 1 : 0) != 0, (String)"Accumulated NaN for topic = (%d,%d)", (Object[])new Object[]{topicWord.getFirst(), topicWord.getSecond()});
            }
            context.write((Object)topicWord, (Object)new DoubleWritable(accum));
        }
    }
}

