/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.clustering.lda;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.mahout.clustering.lda.LDADriver;
import org.apache.mahout.clustering.lda.LDAInference;
import org.apache.mahout.clustering.lda.LDAState;
import org.apache.mahout.math.Vector;
import org.apache.mahout.math.VectorWritable;

public class LDADocumentTopicMapper
extends Mapper<WritableComparable<?>, VectorWritable, WritableComparable<?>, VectorWritable> {
    private LDAInference infer;

    protected void map(WritableComparable<?> key, VectorWritable wordCountsWritable, Mapper.Context context) throws IOException, InterruptedException {
        Vector wordCounts = wordCountsWritable.get();
        try {
            LDAInference.InferredDocument doc = this.infer.infer(wordCounts);
            context.write(key, (Object)new VectorWritable(doc.getGamma().normalize(1.0)));
        }
        catch (ArrayIndexOutOfBoundsException e1) {
            throw new IllegalStateException("This is probably because the --numWords argument is set too small.  \n\tIt needs to be >= than the number of words (terms actually) in the corpus and can be \n\tlarger if some storage inefficiency can be tolerated.", e1);
        }
    }

    public void configure(LDAState myState) {
        this.infer = new LDAInference(myState);
    }

    public void configure(Configuration job) {
        LDAState myState = LDADriver.createState(job);
        this.configure(myState);
    }

    protected void setup(Mapper.Context context) {
        this.configure(context.getConfiguration());
    }
}

