/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.clustering.kmeans;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Reducer;
import org.apache.mahout.clustering.ClusterObservations;
import org.apache.mahout.clustering.kmeans.Cluster;
import org.apache.mahout.clustering.kmeans.KMeansClusterer;
import org.apache.mahout.clustering.kmeans.KMeansUtil;
import org.apache.mahout.common.distance.DistanceMeasure;

public class KMeansReducer
extends Reducer<Text, ClusterObservations, Text, Cluster> {
    private Map<String, Cluster> clusterMap;
    private double convergenceDelta;
    private KMeansClusterer clusterer;

    protected void reduce(Text key, Iterable<ClusterObservations> values, Reducer.Context context) throws IOException, InterruptedException {
        Cluster cluster = this.clusterMap.get(key.toString());
        for (ClusterObservations delta : values) {
            cluster.observe(delta);
        }
        boolean converged = this.clusterer.computeConvergence(cluster, this.convergenceDelta);
        if (converged) {
            context.getCounter("Clustering", "Converged Clusters").increment(1L);
        }
        cluster.computeParameters();
        context.write((Object)new Text(cluster.getIdentifier()), (Object)cluster);
    }

    protected void setup(Reducer.Context context) throws IOException, InterruptedException {
        super.setup(context);
        Configuration conf = context.getConfiguration();
        try {
            ClassLoader ccl = Thread.currentThread().getContextClassLoader();
            DistanceMeasure measure = ccl.loadClass(conf.get("org.apache.mahout.clustering.kmeans.measure")).asSubclass(DistanceMeasure.class).newInstance();
            measure.configure(conf);
            this.convergenceDelta = Double.parseDouble(conf.get("org.apache.mahout.clustering.kmeans.convergence"));
            this.clusterer = new KMeansClusterer(measure);
            this.clusterMap = new HashMap<String, Cluster>();
            String path = conf.get("org.apache.mahout.clustering.kmeans.path");
            if (path.length() > 0) {
                ArrayList<Cluster> clusters = new ArrayList<Cluster>();
                KMeansUtil.configureWithClusterInfo(conf, new Path(path), clusters);
                this.setClusterMap(clusters);
                if (this.clusterMap.isEmpty()) {
                    throw new IllegalStateException("Cluster is empty!");
                }
            }
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException(e);
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException(e);
        }
        catch (InstantiationException e) {
            throw new IllegalStateException(e);
        }
    }

    private void setClusterMap(Collection<Cluster> clusters) {
        this.clusterMap = new HashMap<String, Cluster>();
        for (Cluster cluster : clusters) {
            this.clusterMap.put(cluster.getIdentifier(), cluster);
        }
        clusters.clear();
    }

    public void setup(Collection<Cluster> clusters, DistanceMeasure measure) {
        this.setClusterMap(clusters);
        this.clusterer = new KMeansClusterer(measure);
    }
}

