/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.clustering.kmeans;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.mahout.clustering.ClusterObservations;
import org.apache.mahout.clustering.kmeans.Cluster;
import org.apache.mahout.clustering.kmeans.KMeansClusterer;
import org.apache.mahout.clustering.kmeans.KMeansUtil;
import org.apache.mahout.common.distance.DistanceMeasure;
import org.apache.mahout.math.VectorWritable;

public class KMeansMapper
extends Mapper<WritableComparable<?>, VectorWritable, Text, ClusterObservations> {
    private KMeansClusterer clusterer;
    private final Collection<Cluster> clusters = new ArrayList<Cluster>();

    protected void map(WritableComparable<?> key, VectorWritable point, Mapper.Context context) throws IOException, InterruptedException {
        this.clusterer.emitPointToNearestCluster(point.get(), this.clusters, context);
    }

    protected void setup(Mapper.Context context) throws IOException, InterruptedException {
        super.setup(context);
        Configuration conf = context.getConfiguration();
        try {
            ClassLoader ccl = Thread.currentThread().getContextClassLoader();
            DistanceMeasure measure = ccl.loadClass(conf.get("org.apache.mahout.clustering.kmeans.measure")).asSubclass(DistanceMeasure.class).newInstance();
            measure.configure(conf);
            this.clusterer = new KMeansClusterer(measure);
            String clusterPath = conf.get("org.apache.mahout.clustering.kmeans.path");
            if (clusterPath != null && clusterPath.length() > 0) {
                KMeansUtil.configureWithClusterInfo(conf, new Path(clusterPath), this.clusters);
                if (this.clusters.isEmpty()) {
                    throw new IllegalStateException("No clusters found. Check your -c path.");
                }
            }
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException(e);
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException(e);
        }
        catch (InstantiationException e) {
            throw new IllegalStateException(e);
        }
    }

    void setup(Collection<Cluster> clusters, DistanceMeasure measure) {
        this.clusters.clear();
        this.clusters.addAll(clusters);
        this.clusterer = new KMeansClusterer(measure);
    }
}

