/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.clustering.kmeans;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.mahout.clustering.AbstractCluster;
import org.apache.mahout.clustering.ClusterObservations;
import org.apache.mahout.clustering.WeightedVectorWritable;
import org.apache.mahout.clustering.kmeans.Cluster;
import org.apache.mahout.common.distance.DistanceMeasure;
import org.apache.mahout.math.Vector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KMeansClusterer {
    private static final Logger log = LoggerFactory.getLogger(KMeansClusterer.class);
    private final DistanceMeasure measure;

    public KMeansClusterer(DistanceMeasure measure) {
        this.measure = measure;
    }

    public void emitPointToNearestCluster(Vector point, Iterable<Cluster> clusters, Mapper.Context context) throws IOException, InterruptedException {
        Cluster nearestCluster = null;
        double nearestDistance = Double.MAX_VALUE;
        for (Cluster cluster : clusters) {
            Vector clusterCenter = cluster.getCenter();
            double distance = this.measure.distance(clusterCenter.getLengthSquared(), clusterCenter, point);
            if (log.isDebugEnabled()) {
                log.debug("{} Cluster: {}", (Object)distance, (Object)cluster.getId());
            }
            if (!(distance < nearestDistance) && nearestCluster != null) continue;
            nearestCluster = cluster;
            nearestDistance = distance;
        }
        context.write((Object)new Text(nearestCluster.getIdentifier()), (Object)new ClusterObservations(1.0, point, point.times(point)));
    }

    protected void addPointToNearestCluster(Vector point, Iterable<Cluster> clusters) {
        AbstractCluster closestCluster = null;
        double closestDistance = Double.MAX_VALUE;
        for (Cluster cluster : clusters) {
            double distance = this.measure.distance(cluster.getCenter(), point);
            if (closestCluster != null && !(closestDistance > distance)) continue;
            closestCluster = cluster;
            closestDistance = distance;
        }
        closestCluster.observe(point, 1.0);
    }

    protected boolean testConvergence(Iterable<Cluster> clusters, double distanceThreshold) {
        boolean converged = true;
        for (Cluster cluster : clusters) {
            if (!this.computeConvergence(cluster, distanceThreshold)) {
                converged = false;
            }
            cluster.computeParameters();
        }
        return converged;
    }

    public void outputPointWithClusterInfo(Vector vector, Iterable<Cluster> clusters, Mapper.Context context) throws IOException, InterruptedException {
        AbstractCluster nearestCluster = null;
        double nearestDistance = Double.MAX_VALUE;
        for (Cluster cluster : clusters) {
            Vector clusterCenter = cluster.getCenter();
            double distance = this.measure.distance(clusterCenter.getLengthSquared(), clusterCenter, vector);
            if (!(distance < nearestDistance) && nearestCluster != null) continue;
            nearestCluster = cluster;
            nearestDistance = distance;
        }
        context.write((Object)new IntWritable(nearestCluster.getId()), (Object)new WeightedVectorWritable(1.0, vector));
    }

    protected void emitPointToNearestCluster(Vector point, Iterable<Cluster> clusters, SequenceFile.Writer writer) throws IOException {
        AbstractCluster nearestCluster = null;
        double nearestDistance = Double.MAX_VALUE;
        for (Cluster cluster : clusters) {
            Vector clusterCenter = cluster.getCenter();
            double distance = this.measure.distance(clusterCenter.getLengthSquared(), clusterCenter, point);
            if (log.isDebugEnabled()) {
                log.debug("{} Cluster: {}", (Object)distance, (Object)cluster.getId());
            }
            if (!(distance < nearestDistance) && nearestCluster != null) continue;
            nearestCluster = cluster;
            nearestDistance = distance;
        }
        writer.append((Writable)new IntWritable(nearestCluster.getId()), (Writable)new WeightedVectorWritable(1.0, point));
    }

    public static List<List<Cluster>> clusterPoints(Iterable<Vector> points, List<Cluster> clusters, DistanceMeasure measure, int maxIter, double distanceThreshold) {
        ArrayList<List<Cluster>> clustersList = new ArrayList<List<Cluster>>();
        clustersList.add(clusters);
        boolean converged = false;
        for (int iteration = 0; !converged && iteration < maxIter; ++iteration) {
            log.info("Reference Iteration: " + iteration);
            ArrayList<Cluster> next = new ArrayList<Cluster>();
            for (Cluster c : (List)clustersList.get(iteration)) {
                next.add(new Cluster(c.getCenter(), c.getId(), measure));
            }
            clustersList.add(next);
            converged = KMeansClusterer.runKMeansIteration(points, next, measure, distanceThreshold);
        }
        return clustersList;
    }

    protected static boolean runKMeansIteration(Iterable<Vector> points, Iterable<Cluster> clusters, DistanceMeasure measure, double distanceThreshold) {
        KMeansClusterer clusterer = new KMeansClusterer(measure);
        for (Vector point : points) {
            clusterer.addPointToNearestCluster(point, clusters);
        }
        return clusterer.testConvergence(clusters, distanceThreshold);
    }

    public boolean computeConvergence(Cluster cluster, double distanceThreshold) {
        return cluster.computeConvergence(this.measure, distanceThreshold);
    }
}

