/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.clustering.fuzzykmeans;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Writable;
import org.apache.mahout.clustering.canopy.Canopy;
import org.apache.mahout.clustering.fuzzykmeans.SoftCluster;
import org.apache.mahout.clustering.kmeans.Cluster;
import org.apache.mahout.common.iterator.sequencefile.PathFilters;
import org.apache.mahout.common.iterator.sequencefile.SequenceFileValueIterable;

final class FuzzyKMeansUtil {
    private FuzzyKMeansUtil() {
    }

    public static void configureWithClusterInfo(Path clusterPathStr, Collection<SoftCluster> clusters) throws IOException {
        FileStatus[] matches;
        Configuration conf = new Configuration();
        Path clusterPath = new Path(clusterPathStr, "*");
        ArrayList<Path> result = new ArrayList<Path>();
        FileSystem fs = clusterPath.getFileSystem(conf);
        for (FileStatus match : matches = fs.listStatus(FileUtil.stat2Paths((FileStatus[])fs.globStatus(clusterPath, PathFilters.partFilter())), PathFilters.partFilter())) {
            result.add(fs.makeQualified(match.getPath()));
        }
        for (Path path : result) {
            for (Writable value : new SequenceFileValueIterable(path, conf)) {
                Class<?> valueClass = value.getClass();
                if (valueClass.equals(Cluster.class)) {
                    Cluster cluster = (Cluster)value;
                    clusters.add(new SoftCluster(cluster.getCenter(), cluster.getId(), cluster.getMeasure()));
                    continue;
                }
                if (valueClass.equals(SoftCluster.class)) {
                    clusters.add((SoftCluster)value);
                    continue;
                }
                if (valueClass.equals(Canopy.class)) {
                    Canopy canopy = (Canopy)value;
                    clusters.add(new SoftCluster(canopy.getCenter(), canopy.getId(), canopy.getMeasure()));
                    continue;
                }
                throw new IllegalStateException("Bad value class: " + valueClass);
            }
        }
    }
}

