/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.clustering.fuzzykmeans;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Reducer;
import org.apache.mahout.clustering.ClusterObservations;
import org.apache.mahout.clustering.fuzzykmeans.FuzzyKMeansClusterer;
import org.apache.mahout.clustering.fuzzykmeans.FuzzyKMeansUtil;
import org.apache.mahout.clustering.fuzzykmeans.SoftCluster;

public class FuzzyKMeansReducer
extends Reducer<Text, ClusterObservations, Text, SoftCluster> {
    private final Map<String, SoftCluster> clusterMap = new HashMap<String, SoftCluster>();
    private FuzzyKMeansClusterer clusterer;

    protected void reduce(Text key, Iterable<ClusterObservations> values, Reducer.Context context) throws IOException, InterruptedException {
        SoftCluster cluster = this.clusterMap.get(key.toString());
        for (ClusterObservations value : values) {
            if (value.getCombinerState() == 0) {
                cluster.observe(value.getS1(), Math.pow(value.getS0(), this.clusterer.getM()));
                continue;
            }
            cluster.observe(value);
        }
        boolean converged = this.clusterer.computeConvergence(cluster);
        if (converged) {
            context.getCounter("Clustering", "Converged Clusters").increment(1L);
        }
        cluster.computeParameters();
        context.write((Object)new Text(cluster.getIdentifier()), (Object)cluster);
    }

    protected void setup(Reducer.Context context) throws IOException, InterruptedException {
        super.setup(context);
        Configuration conf = context.getConfiguration();
        this.clusterer = new FuzzyKMeansClusterer(conf);
        ArrayList<SoftCluster> clusters = new ArrayList<SoftCluster>();
        String clusterPath = conf.get("org.apache.mahout.clustering.kmeans.path");
        if (clusterPath != null && clusterPath.length() > 0) {
            FuzzyKMeansUtil.configureWithClusterInfo(new Path(clusterPath), clusters);
            this.setClusterMap(clusters);
        }
        if (this.clusterMap.isEmpty()) {
            throw new IllegalStateException("Cluster is empty!!!");
        }
    }

    private void setClusterMap(Collection<SoftCluster> clusters) {
        this.clusterMap.clear();
        for (SoftCluster cluster : clusters) {
            this.clusterMap.put(cluster.getIdentifier(), cluster);
        }
        clusters.clear();
    }

    public void setup(Collection<SoftCluster> clusters, Configuration conf) {
        this.setClusterMap(clusters);
        this.clusterer = new FuzzyKMeansClusterer(conf);
    }
}

