/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.clustering.fuzzykmeans;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.mahout.clustering.ClusterObservations;
import org.apache.mahout.clustering.fuzzykmeans.FuzzyKMeansClusterer;
import org.apache.mahout.clustering.fuzzykmeans.FuzzyKMeansUtil;
import org.apache.mahout.clustering.fuzzykmeans.SoftCluster;
import org.apache.mahout.math.VectorWritable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FuzzyKMeansMapper
extends Mapper<WritableComparable<?>, VectorWritable, Text, ClusterObservations> {
    private static final Logger log = LoggerFactory.getLogger(FuzzyKMeansMapper.class);
    private final List<SoftCluster> clusters = new ArrayList<SoftCluster>();
    private FuzzyKMeansClusterer clusterer;

    protected void map(WritableComparable<?> key, VectorWritable point, Mapper.Context context) throws IOException, InterruptedException {
        this.clusterer.emitPointProbToCluster(point.get(), this.clusters, context);
    }

    protected void setup(Mapper.Context context) throws IOException, InterruptedException {
        super.setup(context);
        Configuration job = context.getConfiguration();
        this.clusterer = new FuzzyKMeansClusterer(job);
        log.info("In Mapper Configure:");
        String clusterPath = job.get("org.apache.mahout.clustering.kmeans.path");
        if (clusterPath != null && clusterPath.length() > 0) {
            FuzzyKMeansUtil.configureWithClusterInfo(new Path(clusterPath), this.clusters);
        }
        if (this.clusters.isEmpty()) {
            throw new IllegalStateException("No clusters found. Check your -c path.");
        }
    }

    void config(Collection<SoftCluster> clusters) {
        this.clusters.clear();
        this.clusters.addAll(clusters);
    }
}

