/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.clustering.fuzzykmeans;

import java.io.IOException;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Reducer;
import org.apache.mahout.clustering.ClusterObservations;
import org.apache.mahout.clustering.fuzzykmeans.FuzzyKMeansClusterer;
import org.apache.mahout.clustering.fuzzykmeans.SoftCluster;

public class FuzzyKMeansCombiner
extends Reducer<Text, ClusterObservations, Text, ClusterObservations> {
    private FuzzyKMeansClusterer clusterer;

    protected void reduce(Text key, Iterable<ClusterObservations> values, Reducer.Context context) throws IOException, InterruptedException {
        SoftCluster cluster = new SoftCluster();
        for (ClusterObservations value : values) {
            if (value.getCombinerState() == 0) {
                cluster.observe(value.getS1(), Math.pow(value.getS0(), this.clusterer.getM()));
                continue;
            }
            cluster.observe(value);
        }
        context.write((Object)key, (Object)cluster.getObservations().incrementCombinerState());
    }

    protected void setup(Reducer.Context context) throws IOException, InterruptedException {
        super.setup(context);
        this.clusterer = new FuzzyKMeansClusterer(context.getConfiguration());
    }
}

