/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.clustering.fuzzykmeans;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.mahout.clustering.ClusterObservations;
import org.apache.mahout.clustering.WeightedVectorWritable;
import org.apache.mahout.clustering.fuzzykmeans.SoftCluster;
import org.apache.mahout.clustering.kmeans.Cluster;
import org.apache.mahout.common.distance.DistanceMeasure;
import org.apache.mahout.math.DenseVector;
import org.apache.mahout.math.Vector;
import org.apache.mahout.math.VectorWritable;

public class FuzzyKMeansClusterer {
    private static final double MINIMAL_VALUE = 1.0E-10;
    private DistanceMeasure measure;
    private double convergenceDelta;
    private double m = 2.0;
    private boolean emitMostLikely = true;
    private double threshold;

    public FuzzyKMeansClusterer(DistanceMeasure measure, double convergenceDelta, double m) {
        this.measure = measure;
        this.convergenceDelta = convergenceDelta;
        this.m = m;
    }

    public FuzzyKMeansClusterer(Configuration conf) {
        this.configure(conf);
    }

    public FuzzyKMeansClusterer() {
    }

    public static List<List<SoftCluster>> clusterPoints(Iterable<Vector> points, List<SoftCluster> clusters, DistanceMeasure measure, double threshold, double m, int numIter) {
        ArrayList<List<SoftCluster>> clustersList = new ArrayList<List<SoftCluster>>();
        clustersList.add(clusters);
        FuzzyKMeansClusterer clusterer = new FuzzyKMeansClusterer(measure, threshold, m);
        boolean converged = false;
        int iteration = 0;
        for (int iter = 0; !converged && iter < numIter; ++iter) {
            ArrayList<SoftCluster> next = new ArrayList<SoftCluster>();
            List cs = (List)clustersList.get(iteration++);
            for (SoftCluster c : cs) {
                next.add(new SoftCluster(c.getCenter(), c.getId(), measure));
            }
            clustersList.add(next);
            converged = FuzzyKMeansClusterer.runFuzzyKMeansIteration(points, (List)clustersList.get(iteration), clusterer);
        }
        return clustersList;
    }

    protected static boolean runFuzzyKMeansIteration(Iterable<Vector> points, List<SoftCluster> clusterList, FuzzyKMeansClusterer clusterer) {
        for (Vector point : points) {
            clusterer.addPointToClusters(clusterList, point);
        }
        return clusterer.testConvergence(clusterList);
    }

    private void configure(Configuration job) {
        try {
            ClassLoader ccl = Thread.currentThread().getContextClassLoader();
            this.measure = ccl.loadClass(job.get("org.apache.mahout.clustering.kmeans.measure")).asSubclass(DistanceMeasure.class).newInstance();
            this.measure.configure(job);
            this.convergenceDelta = Double.parseDouble(job.get("org.apache.mahout.clustering.kmeans.convergence"));
            this.m = Double.parseDouble(job.get("org.apache.mahout.clustering.fuzzykmeans.m"));
            this.emitMostLikely = Boolean.parseBoolean(job.get("org.apache.mahout.clustering.fuzzykmeans.emitMostLikely"));
            this.threshold = Double.parseDouble(job.get("org.apache.mahout.clustering.fuzzykmeans.threshold"));
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException(e);
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException(e);
        }
        catch (InstantiationException e) {
            throw new IllegalStateException(e);
        }
    }

    public void emitPointProbToCluster(Vector point, List<SoftCluster> clusters, Mapper.Context context) throws IOException, InterruptedException {
        ArrayList<Double> clusterDistanceList = new ArrayList<Double>();
        for (SoftCluster cluster : clusters) {
            clusterDistanceList.add(this.measure.distance(cluster.getCenter(), point));
        }
        for (int i = 0; i < clusters.size(); ++i) {
            SoftCluster cluster;
            cluster = clusters.get(i);
            Text key = new Text(cluster.getIdentifier());
            ClusterObservations value = new ClusterObservations(this.computeProbWeight((Double)clusterDistanceList.get(i), clusterDistanceList), point, point.times(point));
            context.write((Object)key, (Object)value);
        }
    }

    public double computeProbWeight(double clusterDistance, Iterable<Double> clusterDistanceList) {
        if (clusterDistance == 0.0) {
            clusterDistance = 1.0E-10;
        }
        double denom = 0.0;
        for (double eachCDist : clusterDistanceList) {
            if (eachCDist == 0.0) {
                eachCDist = 1.0E-10;
            }
            denom += Math.pow(clusterDistance / eachCDist, 2.0 / (this.m - 1.0));
        }
        return 1.0 / denom;
    }

    public boolean computeConvergence(Cluster cluster) {
        return cluster.computeConvergence(this.measure, this.convergenceDelta);
    }

    public double getM() {
        return this.m;
    }

    public DistanceMeasure getMeasure() {
        return this.measure;
    }

    public void emitPointToClusters(VectorWritable point, List<SoftCluster> clusters, Mapper.Context context) throws IOException, InterruptedException {
        ArrayList<Double> clusterDistanceList = new ArrayList<Double>();
        for (SoftCluster cluster : clusters) {
            clusterDistanceList.add(this.getMeasure().distance(cluster.getCenter(), point.get()));
        }
        Vector pi = this.computePi(clusters, clusterDistanceList);
        if (this.emitMostLikely) {
            this.emitMostLikelyCluster(point.get(), clusters, pi, context);
        } else {
            this.emitAllClusters(point.get(), clusters, pi, context);
        }
    }

    public Vector computePi(Collection<SoftCluster> clusters, List<Double> clusterDistanceList) {
        DenseVector pi = new DenseVector(clusters.size());
        for (int i = 0; i < clusters.size(); ++i) {
            double probWeight = this.computeProbWeight(clusterDistanceList.get(i), clusterDistanceList);
            pi.set(i, probWeight);
        }
        return pi;
    }

    private void emitMostLikelyCluster(Vector point, List<SoftCluster> clusters, Vector pi, Mapper.Context context) throws IOException, InterruptedException {
        int clusterId = -1;
        double clusterPdf = 0.0;
        for (int i = 0; i < clusters.size(); ++i) {
            double pdf = pi.get(i);
            if (!(pdf > clusterPdf)) continue;
            clusterId = clusters.get(i).getId();
            clusterPdf = pdf;
        }
        context.write((Object)new IntWritable(clusterId), (Object)new WeightedVectorWritable(clusterPdf, point));
    }

    private void emitAllClusters(Vector point, Collection<SoftCluster> clusters, Vector pi, Mapper.Context context) throws IOException, InterruptedException {
        for (int i = 0; i < clusters.size(); ++i) {
            double pdf = pi.get(i);
            if (!(pdf > this.threshold)) continue;
            context.write((Object)new IntWritable(i), (Object)new WeightedVectorWritable(pdf, point));
        }
    }

    protected void addPointToClusters(List<SoftCluster> clusterList, Vector point) {
        ArrayList<Double> clusterDistanceList = new ArrayList<Double>();
        for (SoftCluster cluster : clusterList) {
            clusterDistanceList.add(this.getMeasure().distance(point, cluster.getCenter()));
        }
        for (int i = 0; i < clusterList.size(); ++i) {
            double probWeight = this.computeProbWeight((Double)clusterDistanceList.get(i), clusterDistanceList);
            clusterList.get(i).observe(point, Math.pow(probWeight, this.getM()));
        }
    }

    protected boolean testConvergence(Iterable<SoftCluster> clusters) {
        boolean converged = true;
        for (SoftCluster cluster : clusters) {
            if (!cluster.computeConvergence(this.measure, this.convergenceDelta)) {
                converged = false;
            }
            cluster.computeParameters();
        }
        return converged;
    }

    public void emitPointToClusters(VectorWritable point, List<SoftCluster> clusters, SequenceFile.Writer writer) throws IOException {
        ArrayList<Double> clusterDistanceList = new ArrayList<Double>();
        for (SoftCluster cluster : clusters) {
            clusterDistanceList.add(this.getMeasure().distance(cluster.getCenter(), point.get()));
        }
        Vector pi = this.computePi(clusters, clusterDistanceList);
        if (this.emitMostLikely) {
            FuzzyKMeansClusterer.emitMostLikelyCluster(point.get(), clusters, pi, writer);
        } else {
            this.emitAllClusters(point.get(), clusters, pi, writer);
        }
    }

    private void emitAllClusters(Vector point, Collection<SoftCluster> clusters, Vector pi, SequenceFile.Writer writer) throws IOException {
        for (int i = 0; i < clusters.size(); ++i) {
            double pdf = pi.get(i);
            if (!(pdf > this.threshold)) continue;
            writer.append((Writable)new IntWritable(i), (Writable)new WeightedVectorWritable(pdf, point));
        }
    }

    private static void emitMostLikelyCluster(Vector point, List<SoftCluster> clusters, Vector pi, SequenceFile.Writer writer) throws IOException {
        int clusterId = -1;
        double clusterPdf = 0.0;
        for (int i = 0; i < clusters.size(); ++i) {
            double pdf = pi.get(i);
            if (!(pdf > clusterPdf)) continue;
            clusterId = clusters.get(i).getId();
            clusterPdf = pdf;
        }
        writer.append((Writable)new IntWritable(clusterId), (Writable)new WeightedVectorWritable(clusterPdf, point));
    }
}

