/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.clustering.fuzzykmeans;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.mahout.clustering.WeightedVectorWritable;
import org.apache.mahout.clustering.fuzzykmeans.FuzzyKMeansClusterer;
import org.apache.mahout.clustering.fuzzykmeans.FuzzyKMeansUtil;
import org.apache.mahout.clustering.fuzzykmeans.SoftCluster;
import org.apache.mahout.math.VectorWritable;

public class FuzzyKMeansClusterMapper
extends Mapper<WritableComparable<?>, VectorWritable, IntWritable, WeightedVectorWritable> {
    private final List<SoftCluster> clusters = new ArrayList<SoftCluster>();
    private FuzzyKMeansClusterer clusterer;

    protected void map(WritableComparable<?> key, VectorWritable point, Mapper.Context context) throws IOException, InterruptedException {
        this.clusterer.emitPointToClusters(point, this.clusters, context);
    }

    protected void setup(Mapper.Context context) throws IOException, InterruptedException {
        super.setup(context);
        Configuration conf = context.getConfiguration();
        this.clusterer = new FuzzyKMeansClusterer(conf);
        String clusterPath = conf.get("org.apache.mahout.clustering.kmeans.path");
        if (clusterPath != null && clusterPath.length() > 0) {
            FuzzyKMeansUtil.configureWithClusterInfo(new Path(clusterPath), this.clusters);
        }
        if (this.clusters.isEmpty()) {
            throw new IllegalStateException("Cluster is empty!!!");
        }
    }

    void setup(Collection<SoftCluster> clusters, Configuration conf) {
        this.clusters.clear();
        this.clusters.addAll(clusters);
        this.clusterer = new FuzzyKMeansClusterer(conf);
    }
}

