/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.clustering.dirichlet.models;

import org.apache.mahout.clustering.Model;
import org.apache.mahout.clustering.dirichlet.UncommonDistributions;
import org.apache.mahout.clustering.dirichlet.models.AbstractVectorModelDistribution;
import org.apache.mahout.clustering.dirichlet.models.GaussianCluster;
import org.apache.mahout.math.Vector;
import org.apache.mahout.math.VectorWritable;

public class GaussianClusterDistribution
extends AbstractVectorModelDistribution {
    public GaussianClusterDistribution() {
    }

    public GaussianClusterDistribution(VectorWritable modelPrototype) {
        super(modelPrototype);
    }

    @Override
    public Model<VectorWritable>[] sampleFromPrior(int howMany) {
        GaussianCluster[] result = new GaussianCluster[howMany];
        for (int i = 0; i < howMany; ++i) {
            Vector prototype = this.getModelPrototype().get();
            Vector mean = prototype.like();
            for (int j = 0; j < prototype.size(); ++j) {
                mean.set(j, UncommonDistributions.rNorm(0.0, 1.0));
            }
            Vector sd = prototype.like();
            for (int j = 0; j < prototype.size(); ++j) {
                sd.set(j, UncommonDistributions.rNorm(1.0, 1.0));
            }
            result[i] = new GaussianCluster(mean, sd, i);
        }
        return result;
    }

    @Override
    public Model<VectorWritable>[] sampleFromPosterior(Model<VectorWritable>[] posterior) {
        GaussianCluster[] result = new GaussianCluster[posterior.length];
        for (int i = 0; i < posterior.length; ++i) {
            result[i] = posterior[i].sampleFromPosterior();
        }
        return result;
    }
}

