/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.clustering.dirichlet.models;

import org.apache.mahout.clustering.AbstractCluster;
import org.apache.mahout.clustering.Model;
import org.apache.mahout.clustering.dirichlet.UncommonDistributions;
import org.apache.mahout.math.Vector;
import org.apache.mahout.math.VectorWritable;

public class GaussianCluster
extends AbstractCluster {
    public GaussianCluster() {
    }

    public GaussianCluster(Vector point, int id2) {
        super(point, id2);
    }

    public GaussianCluster(Vector center, Vector radius, int id) {
        super(center, radius, id);
    }

    @Override
    public String getIdentifier() {
        return "GC:" + this.getId();
    }

    @Override
    public Model<VectorWritable> sampleFromPosterior() {
        return new GaussianCluster(this.getCenter(), this.getRadius(), this.getId());
    }

    @Override
    public double pdf(VectorWritable vw) {
        Vector x = vw.get();
        double pdf = 1.0;
        for (int i = 0; i < x.size(); ++i) {
            pdf *= UncommonDistributions.dNorm(x.getQuick(i), this.getCenter().getQuick(i), this.getRadius().getQuick(i) + 1.0E-6);
        }
        return pdf;
    }
}

