/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.clustering.dirichlet.models;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import org.apache.mahout.clustering.ModelDistribution;
import org.apache.mahout.clustering.dirichlet.models.AbstractVectorModelDistribution;
import org.apache.mahout.clustering.dirichlet.models.DistanceMeasureClusterDistribution;
import org.apache.mahout.common.distance.DistanceMeasure;
import org.apache.mahout.math.Vector;
import org.apache.mahout.math.VectorWritable;

public final class DistributionDescription {
    private final String modelFactory;
    private final String modelPrototype;
    private final String distanceMeasure;
    private final int prototypeSize;

    public DistributionDescription(String modelFactory, String modelPrototype, String distanceMeasure, int prototypeSize) {
        this.modelFactory = modelFactory;
        this.modelPrototype = modelPrototype;
        this.distanceMeasure = distanceMeasure;
        this.prototypeSize = prototypeSize;
    }

    public String getModelFactory() {
        return this.modelFactory;
    }

    public String getModelPrototype() {
        return this.modelPrototype;
    }

    public String getDistanceMeasure() {
        return this.distanceMeasure;
    }

    public int getPrototypeSize() {
        return this.prototypeSize;
    }

    public ModelDistribution<VectorWritable> createModelDistribution() {
        AbstractVectorModelDistribution modelDistribution;
        ClassLoader ccl = Thread.currentThread().getContextClassLoader();
        try {
            Class<AbstractVectorModelDistribution> cl = ccl.loadClass(this.modelFactory).asSubclass(AbstractVectorModelDistribution.class);
            modelDistribution = cl.newInstance();
            Class<Vector> vcl = ccl.loadClass(this.modelPrototype).asSubclass(Vector.class);
            Constructor<Vector> v = vcl.getConstructor(Integer.TYPE);
            modelDistribution.setModelPrototype(new VectorWritable(v.newInstance(this.prototypeSize)));
            if (modelDistribution instanceof DistanceMeasureClusterDistribution) {
                Class<DistanceMeasure> measureCl = ccl.loadClass(this.distanceMeasure).asSubclass(DistanceMeasure.class);
                DistanceMeasure measure = measureCl.newInstance();
                ((DistanceMeasureClusterDistribution)modelDistribution).setMeasure(measure);
            }
        }
        catch (ClassNotFoundException cnfe) {
            throw new IllegalStateException(cnfe);
        }
        catch (NoSuchMethodException nsme) {
            throw new IllegalStateException(nsme);
        }
        catch (InstantiationException ie) {
            throw new IllegalStateException(ie);
        }
        catch (IllegalAccessException iae) {
            throw new IllegalStateException(iae);
        }
        catch (InvocationTargetException ite) {
            throw new IllegalStateException(ite);
        }
        return modelDistribution;
    }

    public String toString() {
        return this.modelFactory + ',' + this.modelPrototype + ',' + this.distanceMeasure + ',' + this.prototypeSize;
    }

    public static DistributionDescription fromString(String s) {
        String[] tokens = s.split(",");
        return new DistributionDescription(tokens[0], tokens[1], tokens[2], Integer.parseInt(tokens[3]));
    }
}

