/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.clustering.dirichlet.models;

import org.apache.mahout.clustering.DistanceMeasureCluster;
import org.apache.mahout.clustering.Model;
import org.apache.mahout.clustering.dirichlet.models.AbstractVectorModelDistribution;
import org.apache.mahout.common.distance.DistanceMeasure;
import org.apache.mahout.common.distance.ManhattanDistanceMeasure;
import org.apache.mahout.math.Vector;
import org.apache.mahout.math.VectorWritable;

public class DistanceMeasureClusterDistribution
extends AbstractVectorModelDistribution {
    private DistanceMeasure measure;

    public DistanceMeasureClusterDistribution() {
    }

    public DistanceMeasureClusterDistribution(VectorWritable modelPrototype) {
        super(modelPrototype);
        this.measure = new ManhattanDistanceMeasure();
    }

    public DistanceMeasureClusterDistribution(VectorWritable modelPrototype, DistanceMeasure measure) {
        super(modelPrototype);
        this.measure = measure;
    }

    @Override
    public Model<VectorWritable>[] sampleFromPrior(int howMany) {
        DistanceMeasureCluster[] result = new DistanceMeasureCluster[howMany];
        for (int i = 0; i < howMany; ++i) {
            Vector prototype = this.getModelPrototype().get();
            result[i] = new DistanceMeasureCluster(prototype.like(), i, this.measure);
        }
        return result;
    }

    @Override
    public Model<VectorWritable>[] sampleFromPosterior(Model<VectorWritable>[] posterior) {
        DistanceMeasureCluster[] result = new DistanceMeasureCluster[posterior.length];
        for (int i = 0; i < posterior.length; ++i) {
            result[i] = posterior[i].sampleFromPosterior();
        }
        return result;
    }

    public void setMeasure(DistanceMeasure measure) {
        this.measure = measure;
    }

    public DistanceMeasure getMeasure() {
        return this.measure;
    }
}

