/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.clustering.dirichlet;

import java.util.Random;
import org.apache.mahout.common.RandomUtils;
import org.apache.mahout.math.DenseVector;
import org.apache.mahout.math.Vector;
import org.uncommons.maths.random.GaussianGenerator;

public final class UncommonDistributions {
    private static final double SQRT2PI = Math.sqrt(Math.PI * 2);
    private static final Random RANDOM = RandomUtils.getRandom();

    private UncommonDistributions() {
    }

    public static double rGamma(double k, double lambda) {
        double x;
        boolean accept = false;
        if (k >= 1.0) {
            double x2;
            double b = k - Math.log(4.0);
            double c = k + Math.sqrt(2.0 * k - 1.0);
            double lam = Math.sqrt(2.0 * k - 1.0);
            double cheng = 1.0 + Math.log(4.5);
            do {
                double z;
                double u = RANDOM.nextDouble();
                double v = RANDOM.nextDouble();
                double y = 1.0 / lam * Math.log(v / (1.0 - v));
                double r = b + c * y - (x2 = k * Math.exp(y));
                if (!(r >= 4.5 * (z = u * v * v) - cheng) && !(r >= Math.log(z))) continue;
                accept = true;
            } while (!accept);
            return x2 / lambda;
        }
        double c = 1.0 / k;
        double d = (1.0 - k) * Math.pow(k, k / (1.0 - k));
        do {
            double e;
            double u = RANDOM.nextDouble();
            double v = RANDOM.nextDouble();
            double z = -Math.log(u);
            if (!(z + (e = -Math.log(v)) >= d + (x = Math.pow(z, c)))) continue;
            accept = true;
        } while (!accept);
        return x / lambda;
    }

    public static double rBeta(double shape1, double shape2) {
        double gam1 = UncommonDistributions.rGamma(shape1, 1.0);
        double gam2 = UncommonDistributions.rGamma(shape2, 1.0);
        return gam1 / (gam1 + gam2);
    }

    public static Vector rBeta(int k, double shape1, double shape2) {
        DenseVector result = new DenseVector(k);
        for (int i = 0; i < k; ++i) {
            result.set(i, UncommonDistributions.rBeta(shape1, shape2));
        }
        return result;
    }

    public static double rChisq(double df) {
        double result = 0.0;
        int i = 0;
        while ((double)i < df) {
            double sample = UncommonDistributions.rNorm(0.0, 1.0);
            result += sample * sample;
            ++i;
        }
        return result;
    }

    public static double rNorm(double mean, double sd) {
        GaussianGenerator dist = new GaussianGenerator(mean, sd, RANDOM);
        return dist.nextValue();
    }

    public static double dNorm(double x, double m, double s) {
        double xms = (x - m) / s;
        double ex = xms * xms / 2.0;
        double exp = Math.exp(-ex);
        return exp / (SQRT2PI * s);
    }

    public static int rMultinom(Vector probabilities) {
        double total = probabilities.zSum();
        double nextDouble = RANDOM.nextDouble();
        double p = nextDouble * total;
        for (int i = 0; i < probabilities.size(); ++i) {
            double pi = probabilities.get(i);
            if (p < pi) {
                return i;
            }
            p -= pi;
        }
        return 0;
    }

    public static Vector rMultinom(int size, Vector probabilities) {
        double total = probabilities.zSum();
        int cardinality = probabilities.size();
        DenseVector result = new DenseVector(cardinality);
        for (int i = 0; total > 0.0 && i < cardinality; ++i) {
            double p = probabilities.get(i);
            int ki = UncommonDistributions.rBinomial(size, p / total);
            total -= p;
            size -= ki;
            result.set(i, (double)ki);
        }
        return result;
    }

    public static int rBinomial(int n, double p) {
        if (p >= 1.0) {
            return n;
        }
        double q = -Math.log(1.0 - p);
        double sum = 0.0;
        int x = 0;
        while (sum <= q) {
            double u = RANDOM.nextDouble();
            double e = -Math.log(u);
            sum += e / (double)(n - x);
            ++x;
        }
        if (x == 0) {
            return 0;
        }
        return x - 1;
    }

    public static Vector rDirichlet(Vector totalCounts, double alpha0) {
        Vector pi = totalCounts.like();
        double total = totalCounts.zSum();
        double remainder = 1.0;
        for (int k = 0; k < pi.size(); ++k) {
            double countK = totalCounts.get(k);
            double betaK = UncommonDistributions.rBeta(1.0 + countK, Math.max(0.0, alpha0 + (total -= countK)));
            double piK = betaK * remainder;
            pi.set(k, piK);
            remainder -= piK;
        }
        return pi;
    }
}

